<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('klients')) {
    header("Location: ../index.php");
    exit();
}

$db = Database::getInstance();
$current_user = $auth->getCurrentUser();

// Iegūstam klienta pierakstus uz nodarbībām
$pieraksti = $db->izpilditVaicajumu("
    SELECT p.*, n.nosaukums, n.sakuma_laiks, n.beigu_laiks, n.stavoklis,
           l.vards AS trenera_vards, l.uzvards AS trenera_uzvards
    FROM pieraksti p
    LEFT JOIN nodarbibas n ON p.nodarbibas_id = n.id
    LEFT JOIN lietotaji l ON n.treneris_id = l.id
    WHERE p.lietotaja_id = ?
    ORDER BY n.sakuma_laiks DESC
", [$current_user['id']])->fetchAll();

// Statistika
$kopais_pieraksti = count($pieraksti);
$nakamie_pieraksti = 0;
$ieprieksejas_nodarbibas = 0;

foreach ($pieraksti as $pieraksts) {
    if (strtotime($pieraksts['sakuma_laiks']) > time()) {
        $nakamie_pieraksti++;
    } else {
        $ieprieksejas_nodarbibas++;
    }
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mans progress - Klients</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-info">
        <div class="container">
            <a class="navbar-brand" href="#">💪 Sporta Zāle - Klients</a>
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3">
                    Sveiks, <?php echo htmlspecialchars($current_user['vards']); ?>!
                </span>
                <a class="nav-link" href="index.php">Panelis</a>
                <a class="nav-link" href="nodarbibas.php">Nodarbības</a>
                <a class="nav-link" href="mans_progress.php">Mans progress</a>
                <a class="nav-link" href="../dashboard.php">Dashboard</a>
                <a class="nav-link" href="../includes/izlogoties.php">Izlogoties</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h1>Mans progress</h1>
        
        <!-- Statistika -->
        <div class="row mt-4">
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <h5 class="card-title">Kopējais pierakstu skaits</h5>
                        <p class="card-text display-6"><?php echo $kopais_pieraksti; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <h5 class="card-title">Nākamās nodarbības</h5>
                        <p class="card-text display-6"><?php echo $nakamie_pieraksti; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-secondary">
                    <div class="card-body">
                        <h5 class="card-title">Iepriekšējās nodarbības</h5>
                        <p class="card-text display-6"><?php echo $ieprieksejas_nodarbibas; ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Nākamās nodarbības -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Manas nākamās nodarbības</h5>
            </div>
            <div class="card-body">
                <?php 
                $nakamas_nodarbibas = array_filter($pieraksti, function($p) {
                    return strtotime($p['sakuma_laiks']) > time();
                });
                ?>
                
                <?php if (empty($nakamas_nodarbibas)): ?>
                    <div class="alert alert-info">
                        Jums nav gaidāmo nodarbību.
                        <a href="nodarbibas.php" class="alert-link">Pieteikties uz nodarbību</a>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Nodarbība</th>
                                    <th>Treneris</th>
                                    <th>Datums un laiks</th>
                                    <th>Statuss</th>
                                    <th>Darbības</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($nakamas_nodarbibas as $pieraksts): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($pieraksts['nosaukums']); ?></td>
                                        <td><?php echo htmlspecialchars($pieraksts['trenera_vards'] . ' ' . $pieraksts['trenera_uzvards']); ?></td>
                                        <td><?php echo date('d.m.Y H:i', strtotime($pieraksts['sakuma_laiks'])); ?></td>
                                        <td>
                                            <span class="badge 
                                                <?php echo $pieraksts['stavoklis'] == 'aktīva' ? 'bg-success' : 
                                                       ($pieraksts['stavoklis'] == 'atcelta' ? 'bg-danger' : 'bg-secondary'); ?>">
                                                <?php echo $pieraksts['stavoklis']; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <a href="nodarbibas.php?atcelt_pierakstu=<?php echo $pieraksts['id']; ?>" 
                                               class="btn btn-outline-danger btn-sm"
                                               onclick="return confirm('Vai tiešām vēlaties atcelt pierakstu uz nodarbību \"<?php echo addslashes($pieraksts['nosaukums']); ?>\"?')">
                                                Atcelt pierakstu
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Vēsture -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Nodarbību vēsture</h5>
            </div>
            <div class="card-body">
                <?php 
                $vesture = array_filter($pieraksti, function($p) {
                    return strtotime($p['sakuma_laiks']) <= time();
                });
                ?>
                
                <?php if (empty($vesture)): ?>
                    <div class="alert alert-info">
                        Jums vēl nav apmeklētu nodarbību.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Nodarbība</th>
                                    <th>Treneris</th>
                                    <th>Datums un laiks</th>
                                    <th>Statuss</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($vesture as $pieraksts): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($pieraksts['nosaukums']); ?></td>
                                        <td><?php echo htmlspecialchars($pieraksts['trenera_vards'] . ' ' . $pieraksts['trenera_uzvards']); ?></td>
                                        <td><?php echo date('d.m.Y H:i', strtotime($pieraksts['sakuma_laiks'])); ?></td>
                                        <td>
                                            <span class="badge 
                                                <?php echo $pieraksts['stavoklis'] == 'aktīva' ? 'bg-success' : 
                                                       ($pieraksts['stavoklis'] == 'atcelta' ? 'bg-danger' : 'bg-secondary'); ?>">
                                                <?php echo $pieraksts['stavoklis']; ?>
                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>