<?php
require_once 'includes/config.php';
$token = $_GET['token'] ?? '';
$kļūda = '';
$veiksme = '';

error_log("=== PAROLES ATJAUNOŠANAS DEBUG ===");
error_log("Saņemtais token: " . $token);

if (empty($token)) {
    $kļūda = "Nederīgs atjaunošanas links!";
    error_log("Kļūda: Tukšs token");
} else {
    $email = new Email();
    $token_data = $email->parbauditToken($token);

    if (!$token_data) {
        $kļūda = "Nederīgs vai novecojis atjaunošanas links! Lūdzu, pieprasiet jaunu paroles atjaunošanas linku.";
        error_log("Kļūda: Token nav atrasts datu bāzē");
        
        // TESTA REŽĪMS - izveido testa token
        if ($token === "test123") {
            $testa_token = $email->izveidotTestaToken();
            error_log("Izveidots testa token: " . $testa_token);
            $token_data = $email->parbauditToken($testa_token);
            if ($token_data) {
                $kļūda = "";
                error_log("Testa token izveidots veiksmīgi");
            }
        }
    } else {
        error_log("Token atrasts datu bāzē: " . print_r($token_data, true));
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$kļūda) {
    $jauna_parole = $_POST['jauna_parole'];
    $atkartota_parole = $_POST['atkartota_parole'];
    
    if (empty($jauna_parole) || empty($atkartota_parole)) {
        $kļūda = "Lūdzu, aizpildiet visus laukus!";
    } elseif ($jauna_parole !== $atkartota_parole) {
        $kļūda = "Paroles nesakrīt!";
    } elseif (strlen($jauna_parole) < 6) {
        $kļūda = "Parolei jābūt vismaz 6 simbolus garai!";
    } else {
        // Atjaunina paroli
        $hashed_parole = password_hash($jauna_parole, PASSWORD_DEFAULT);
        $db = Database::getInstance();
        
        try {
            $db->izpilditVaicajumu(
                "UPDATE lietotaji SET parole = ? WHERE id = ?",
                [$hashed_parole, $token_data['lietotaja_id']]
            );
            
            // Atzīmē token kā izmantotu
            $email->atzimetTokenKaIzmantotu($token_data['id']);
            
            $veiksme = "Parole veiksmīgi atjaunota! Tagad varat pieslēgties ar jauno paroli.";
            error_log("Parole veiksmīgi atjaunota lietotājam ID: " . $token_data['lietotaja_id']);
            
        } catch (Exception $e) {
            $kļūda = "Kļūda atjauninot paroli: " . $e->getMessage();
            error_log("Kļūda atjauninot paroli: " . $e->getMessage());
        }
    }
}

error_log("=== DEBUG BEIGAS ===");
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jauna Parole - Sporta Zāle</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="login-body">
    <div class="container-fluid h-100">
        <div class="row h-100 justify-content-center align-items-center">
            <div class="col-12 col-md-8 col-lg-6">
                <div class="login-card">
                    <div class="text-center mb-4">
                        <div class="logo-container">
                            <span class="logo-icon">🔑</span>
                            <h1 class="h3 fw-bold">Jauna Parole</h1>
                        </div>
                        <p class="text-muted">Ievadiet jauno paroli</p>
                    </div>

                    <!-- DEBUG INFORMĀCIJA -->
                    <div class="alert alert-warning">
                        <h6>🔧 DEBUG INFORMĀCIJA</h6>
                        <p><strong>Token:</strong> <?php echo htmlspecialchars($token); ?></p>
                        <p><strong>Testa links:</strong> 
                            <a href="<?php echo SITE_URL; ?>jauna_parole.php?token=test123">
                                <?php echo SITE_URL; ?>jauna_parole.php?token=test123
                            </a>
                        </p>
                    </div>

                    <?php if ($kļūda): ?>
                        <div class="alert alert-danger">
                            <h6>❌ Kļūda</h6>
                            <?php echo $kļūda; ?>
                            <?php if (strpos($kļūda, 'novecojis') !== false): ?>
                                <div class="mt-2">
                                    <a href="atjaunot_paroli.php" class="btn btn-sm btn-outline-danger">Pieprasīt jaunu linku</a>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($veiksme): ?>
                        <div class="alert alert-success">
                            <h6>✅ Veiksmīgi!</h6>
                            <?php echo $veiksme; ?>
                            <div class="mt-3">
                                <a href="index.php" class="btn btn-success">Pieslēgties</a>
                            </div>
                        </div>
                    <?php elseif (!$kļūda): ?>
                        <form method="POST" action="">
                            <div class="mb-3">
                                <label for="jauna_parole" class="form-label">Jaunā parole</label>
                                <input type="password" class="form-control" id="jauna_parole" name="jauna_parole" 
                                       placeholder="Vismaz 6 simboli" required>
                                <div class="form-text">Parolei jābūt vismaz 6 simbolus garai.</div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="atkartota_parole" class="form-label">Atkārtot jauno paroli</label>
                                <input type="password" class="form-control" id="atkartota_parole" name="atkartota_parole" 
                                       placeholder="Atkārtot paroli" required>
                            </div>

                            <button type="submit" class="btn btn-primary btn-lg w-100 mb-3">
                                Atjaunot Paroli
                            </button>
                        </form>
                    <?php endif; ?>

                    <div class="text-center mt-3">
                        <a href="index.php" class="text-decoration-none">Atgriezties pie pieslēgšanās</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>