<?php
// Šis ir pieteikšanās lapa sporta zāles sistēmā
// Iekļaut konfigurācijas failu, kas satur sistēmas iestatījumus
require_once 'includes/config.php';
// Pārbaudīt, vai lietotājs jau ir pieteicies sistēmā
if (isset($_SESSION['lietotaja_id'])) {
    // Ja lietotājs ir pieteicies, pārsūtīt uz paneļa lapu
    header("Location: dashboard.php");
    exit();
}
?>
<!-- Beidzas PHP kods, sākas HTML daļa -->
<!DOCTYPE html>
<!-- HTML dokumenta sākums ar latviešu valodu -->
<html lang="lv">
<!-- Galvas daļa ar meta tagiem, nosaukumu un stilu saitēm -->
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pieteikšanās - Sporta Zāle</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="login-body">
    <div class="container-fluid h-100">
        <div class="row h-100 justify-content-center align-items-center">
            <div class="col-12 col-md-6 col-lg-4">
                <div class="login-card">
                    <!-- Logo un virsraksts -->
                    <div class="text-center mb-4">
                        <div class="logo-container">
                            <span class="logo-icon">💪</span>
                            <h1 class="h3 fw-bold">Sporta Zāle</h1>
                        </div>
                        <p class="text-muted">Pieslēdzieties savam kontam</p>
                    </div>

                    <!-- Kļūdu ziņojumi -->
                    <?php if (isset($_SESSION['kļūda'])): ?>
                        <div class="alert alert-danger"><?php echo $_SESSION['kļūda']; unset($_SESSION['kļūda']); ?></div>
                    <?php endif; ?>
                    
                    <?php if (isset($_SESSION['veiksme'])): ?>
                        <div class="alert alert-success"><?php echo $_SESSION['veiksme']; unset($_SESSION['veiksme']); ?></div>
                    <?php endif; ?>

                    <!-- Pieteikšanās forma -->
                    <form action="includes/apstiprinat_pieteiksanos.php" method="POST">
                        <div class="mb-3">
                            <label for="epasts" class="form-label">E-pasts</label>
                            <input type="email" class="form-control form-control-lg" 
                                   id="epasts" name="epasts" 
                                   placeholder="jūsu.epasts@piemērs.lv" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="parole" class="form-label">Parole</label>
                            <input type="password" class="form-control form-control-lg" 
                                   id="parole" name="parole" 
                                   placeholder="Ievadiet paroli" required>
                        </div>

                        <button type="submit" class="btn btn-primary btn-lg w-100 mb-3">
                            <span class="btn-text">Pieslēgties</span>
                            <div class="spinner-border spinner-border-sm d-none" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </button>
                    </form>

                    <!-- Papildu saites -->
                    <div class="text-center">
                        <a href="atjaunot_paroli.php" class="text-decoration-none">Aizmirsāt paroli?</a>
                        <span class="mx-2">•</span>
                        <a href="registreties.php" class="text-decoration-none">Izveidot kontu</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/login.js"></script>
</body>
</html>