<?php
// Pārbauda, vai Database klase jau ir ielādēta
if (!class_exists('Database')) {
    require_once 'Database.php';
}

class User {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function registretLietotaju($vards, $uzvards, $epasts, $parole, $loma = 'klients') {
        // Pārbauda, vai e-pasts jau eksistē
        if ($this->epastsEksiste($epasts)) {
            return false;
        }
        
        $hashedParole = password_hash($parole, PASSWORD_DEFAULT);
        $sql = "INSERT INTO lietotaji (vards, uzvards, epasts, parole, loma) VALUES (?, ?, ?, ?, ?)";
        
        try {
            $this->db->izpilditVaicajumu($sql, [$vards, $uzvards, $epasts, $hashedParole, $loma]);
            return true;
        } catch (PDOException $e) {
            return false;
        }
    }
    
    public function epastsEksiste($epasts) {
        $sql = "SELECT id FROM lietotaji WHERE epasts = ?";
        $atsauce = $this->db->izpilditVaicajumu($sql, [$epasts]);
        return $atsauce->rowCount() > 0;
    }
    
    public function iegutLietotaju($id) {
        $sql = "SELECT * FROM lietotaji WHERE id = ?";
        $atsauce = $this->db->izpilditVaicajumu($sql, [$id]);
        return $atsauce->fetch();
    }
    
    public function atjauninatProfilu($id, $dati) {
        $sql = "UPDATE lietotaji SET vards = ?, uzvards = ?, telefons = ?, dzimsanas_datums = ? WHERE id = ?";
        return $this->db->izpilditVaicajumu($sql, [
            $dati['vards'], 
            $dati['uzvards'], 
            $dati['telefons'], 
            $dati['dzimsanas_datums'], 
            $id
        ]);
    }
}
?>