<?php
class Session {
    public static function set($atslēga, $vērtība) {
        $_SESSION[$atslēga] = $vērtība;
    }
    
    public static function get($atslēga, $noklusējuma = null) {
        return $_SESSION[$atslēga] ?? $noklusējuma;
    }
    
    public static function exists($atslēga) {
        return isset($_SESSION[$atslēga]);
    }
    
    public static function delete($atslēga) {
        if (self::exists($atslēga)) {
            unset($_SESSION[$atslēga]);
        }
    }
    
    public static function flash($atslēga, $vērtība = '') {
        if (self::exists($atslēga)) {
            $sesija = self::get($atslēga);
            self::delete($atslēga);
            return $sesija;
        } else {
            self::set($atslēga, $vērtība);
        }
    }
}
?>