<?php
if (!class_exists('Database')) {
    require_once 'Database.php';
}

class Auth {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function pieslegties($epasts, $parole) {
        $sql = "SELECT * FROM lietotaji WHERE epasts = ? AND aktivizets = 1";
        $atsauce = $this->db->izpilditVaicajumu($sql, [$epasts]);
        $lietotajs = $atsauce->fetch();
        
        if ($lietotajs && password_verify($parole, $lietotajs['parole'])) {
            $_SESSION['lietotaja_id'] = $lietotajs['id'];
            $_SESSION['vards'] = $lietotajs['vards'];
            $_SESSION['uzvards'] = $lietotajs['uzvards'];
            $_SESSION['epasts'] = $lietotajs['epasts'];
            $_SESSION['loma'] = $lietotajs['loma'];
            
            // ATJAUNINA PIERAKSTĪŠANĀS SKAITĪTĀJU UN DATUMU
            $this->atjauninatPierakstisanasDatus($lietotajs['id']);
            
            return true;
        }
        
        return false;
    }
    
    private function atjauninatPierakstisanasDatus($lietotaja_id) {
        // Palielina skaitītāju par 1 un iestata pašreizējo datumu/laiku
        $sql = "UPDATE lietotaji SET 
                pierakstisanas_skaititajs = pierakstisanas_skaititajs + 1, 
                pedeja_pierakstisanas = NOW() 
                WHERE id = ?";
        $this->db->izpilditVaicajumu($sql, [$lietotaja_id]);
    }
    
    public function izlogoties() {
        session_destroy();
        header("Location: ../index.php");
        exit();
    }
    
    public function isLoggedIn() {
        return isset($_SESSION['lietotaja_id']);
    }
    
    public function getCurrentUser() {
        if ($this->isLoggedIn()) {
            return [
                'id' => $_SESSION['lietotaja_id'],
                'vards' => $_SESSION['vards'],
                'uzvards' => $_SESSION['uzvards'],
                'epasts' => $_SESSION['epasts'],
                'loma' => $_SESSION['loma']
            ];
        }
        return null;
    }
    
    public function hasRole($loma) {
        return $this->isLoggedIn() && $_SESSION['loma'] === $loma;
    }
    
    // Papildus metode skaitītāja iegūšanai
    public function iegutPierakstisanasSkaitu($lietotaja_id) {
        $sql = "SELECT pierakstisanas_skaititajs FROM lietotaji WHERE id = ?";
        $result = $this->db->izpilditVaicajumu($sql, [$lietotaja_id]);
        $data = $result->fetch();
        return $data['pierakstisanas_skaititajs'] ?? 0;
    }
}
?>