<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $epasts = trim($_POST['epasts']);
    
    if (empty($epasts) || !filter_var($epasts, FILTER_VALIDATE_EMAIL)) {
        $_SESSION['kļūda'] = "Lūdzu, ievadiet derīgu e-pasta adresi!";
        header("Location: ../atjaunot_paroli.php");
        exit();
    }
    
    $email = new Email();
    $lietotaja_id = $email->atrastLietotajuPecEpasta($epasts);
    
    if ($lietotaja_id) {
        $token = $email->izveidotParolesToken($lietotaja_id);
        
        if ($email->sutitParolesAtjaunosanasEmail($epasts, $token)) {
            $_SESSION['veiksme'] = "Paroles atjaunošanas instrukcijas nosūtītas uz jūsu e-pastu!";
        } else {
            $_SESSION['kļūda'] = "Neizdevās nosūtīt e-pastu. Lūdzu, mēģiniet vēlreiz.";
        }
    } else {
        // Drošības nolūkos nerādām, ka lietotājs neeksistē
        $_SESSION['veiksme'] = "Ja šāds e-pasts eksistē mūsu sistēmā, atjaunošanas instrukcijas tiks nosūtītas.";
    }
    
    header("Location: ../atjaunot_paroli.php");
    exit();
} else {
    header("Location: ../atjaunot_paroli.php");
    exit();
}
?>