<?php
require_once 'includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header("Location: index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panelis - Sporta Zāle</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container mt-5">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h2>Labdien, <?php echo htmlspecialchars($lietotajs['vards']); ?>!</h2>
                    </div>
                    <div class="card-body">
                        <p>E-pasts: <?php echo htmlspecialchars($lietotajs['epasts']); ?></p>
                        <p>Loma: <?php echo htmlspecialchars($lietotajs['loma']); ?></p>
                        
                        <div class="mt-4">
                            <h4>Ātrās darbības:</h4>
                            <div class="row mt-3">
                                <?php if ($auth->hasRole('administrators')): ?>
                                    <div class="col-md-3 mb-2">
                                        <a href="admin/index.php" class="btn btn-primary w-100">Admin Panelis</a>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if ($auth->hasRole('treneris')): ?>
                                    <div class="col-md-3 mb-2">
                                        <a href="treneris/index.php" class="btn btn-success w-100">Trenera Panelis</a>
                                    </div>
                                <?php endif; ?>

                                <div class="col-md-3 mb-2">
                                    <a href="klients/index.php" class="btn btn-info w-100">Klienta Panelis</a>
                                </div>
                                
                                <div class="col-md-3 mb-2">
                                    <a href="includes/izlogoties.php" class="btn btn-danger w-100">Izlogoties</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>