<?php
require_once 'includes/config.php';
if (isset($_SESSION['lietotaja_id'])) {
    header("Location: dashboard.php");
    exit();
}

$kļūda = '';
$veiksme = '';
$testa_token = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $epasts = trim($_POST['epasts']);
    
    if (empty($epasts)) {
        $kļūda = "Lūdzu, ievadiet e-pasta adresi!";
    } elseif (!filter_var($epasts, FILTER_VALIDATE_EMAIL)) {
        $kļūda = "Lūdzu, ievadiet derīgu e-pasta adresi!";
    } else {
        $email = new Email();
        $lietotaja_id = $email->atrastLietotajuPecEpasta($epasts);
        
        if ($lietotaja_id) {
            // Izveido token un nosūta e-pastu (testa režīmā)
            $token = $email->izveidotParolesToken($lietotaja_id);
            
            if ($email->sutitParolesAtjaunosanasEmail($epasts, $token)) {
                $veiksme = "Paroles atjaunošanas instrukcijas nosūtītas!";
                $testa_token = $token; // Parādām token testēšanai
                
                // Saglabā token sesijā administratoriem
                if (isset($_SESSION['lietotaja_id']) && $_SESSION['loma'] == 'administrators') {
                    $_SESSION['testa_token'] = $token;
                }
            }
        } else {
            // Drošības nolūkos nerādām, ka lietotājs neeksistē
            $veiksme = "Ja šāds e-pasts eksistē mūsu sistēmā, atjaunošanas instrukcijas tiks nosūtītas.";
        }
    }
}

// Iegūst pēdējo testa token no faila
$email = new Email();
$pedejais_token = $email->iegutPedejoTestaToken();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Atjaunot paroli - Sporta Zāle</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="login-body">
    <div class="container-fluid h-100">
        <div class="row h-100 justify-content-center align-items-center">
            <div class="col-12 col-md-8 col-lg-6">
                <div class="login-card">
                    <div class="text-center mb-4">
                        <div class="logo-container">
                            <span class="logo-icon">🔐</span>
                            <h1 class="h3 fw-bold">Atjaunot paroli</h1>
                        </div>
                        <p class="text-muted">Ievadiet savu e-pasta adresi</p>
                    </div>

                    <?php if ($kļūda): ?>
                        <div class="alert alert-danger"><?php echo $kļūda; ?></div>
                    <?php endif; ?>
                    
                    <?php if ($veiksme): ?>
                        <div class="alert alert-success">
                            <h5>✅ Veiksmīgi!</h5>
                            <p><?php echo $veiksme; ?></p>
                            
                            <!-- TESTA TOKEN INFORMĀCIJA -->
                            <?php if ($testa_token || $pedejais_token): ?>
                                <div class="mt-3 p-3 bg-light rounded">
                                    <h6>🔧 TESTA REŽĪMS</h6>
                                    <p class="mb-2">E-pasta serveris nav pieejams XAMPP. Izmantojiet šo linku:</p>
                                    <?php 
                                    $token_links = $testa_token ? $testa_token : $pedejais_token;
                                    $atjaunosanasLinks = SITE_URL . "jauna_parole.php?token=" . $token_links;
                                    ?>
                                    <div class="input-group mb-2">
                                        <input type="text" class="form-control" value="<?php echo $atjaunosanasLinks; ?>" readonly>
                                        <button class="btn btn-outline-secondary" type="button" onclick="nokopetLinku()">Kopēt</button>
                                    </div>
                                    <small class="text-muted">Noklikšķiniet uz linka vai nokopējiet to jaunā cilnē</small>
                                </div>
                            <?php endif; ?>
                            
                            <div class="mt-3">
                                <a href="index.php" class="btn btn-success">Atpakaļ uz pieslēgšanos</a>
                            </div>
                        </div>
                    <?php else: ?>
                        <form method="POST" action="">
                            <div class="mb-3">
                                <label for="epasts" class="form-label">E-pasts</label>
                                <input type="email" class="form-control" id="epasts" name="epasts" 
                                       value="<?php echo isset($_POST['epasts']) ? htmlspecialchars($_POST['epasts']) : ''; ?>" 
                                       required>
                            </div>

                            <button type="submit" class="btn btn-primary btn-lg w-100 mb-3">
                                Nosūtīt atjaunošanas linku
                            </button>
                        </form>
                        
                        <!-- TESTA INFORMĀCIJA -->
                        <div class="alert alert-info mt-3">
                            <h6>💡 Testa dati:</h6>
                            <p class="mb-1"><strong>E-pasts:</strong> admin@sportazale.lv</p>
                            <p class="mb-0"><strong>Parole:</strong> password</p>
                        </div>
                    <?php endif; ?>

                    <div class="text-center">
                        <a href="index.php" class="text-decoration-none">Atgriezties pie pieslēgšanās</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
    function nokopetLinku() {
        const linkInput = document.querySelector('input[type="text"]');
        linkInput.select();
        document.execCommand('copy');
        alert('Links nokopēts!');
    }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>