document.addEventListener('DOMContentLoaded', function() {
    const loginForm = document.querySelector('form');
    const submitBtn = loginForm.querySelector('button[type="submit"]');
    
    if (submitBtn) {
        const btnText = submitBtn.querySelector('.btn-text');
        const spinner = submitBtn.querySelector('.spinner-border');
        
        loginForm.addEventListener('submit', function(e) {
            // Validācija
            const email = document.getElementById('epasts').value;
            const password = document.getElementById('parole').value;
            
            if (!isValidEmail(email)) {
                e.preventDefault();
                showError('Lūdzu, ievadiet derīgu e-pasta adresi');
                return;
            }
            
            if (password.length < 6) {
                e.preventDefault();
                showError('Parolei jābūt vismaz 6 simbolus garai');
                return;
            }
            
            // Loading stāvoklis
            if (btnText && spinner) {
                btnText.classList.add('d-none');
                spinner.classList.remove('d-none');
                submitBtn.disabled = true;
            }
        });
    }
    
    function isValidEmail(email) {
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(email);
    }
    
    function showError(message) {
        const oldAlert = document.querySelector('.alert-danger');
        if (oldAlert) {
            oldAlert.remove();
        }
        
        const alert = document.createElement('div');
        alert.className = 'alert alert-danger alert-dismissible fade show mt-3';
        alert.innerHTML = `
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        
        loginForm.parentNode.insertBefore(alert, loginForm);
        
        setTimeout(() => {
            if (alert.parentNode) {
                alert.remove();
            }
        }, 5000);
    }
});