<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('administrators')) {
    header("Location: ../index.php");
    exit();
}

$db = Database::getInstance();

// Iegūst lietotāja datus
$lietotaja_id = $_GET['id'] ?? 0;
$lietotajs = $db->izpilditVaicajumu(
    "SELECT * FROM lietotaji WHERE id = ?", 
    [$lietotaja_id]
)->fetch();

if (!$lietotajs) {
    $_SESSION['kļūda'] = "Lietotājs netika atrasts!";
    header("Location: lietotaji.php");
    exit();
}

$kļūda = '';
$veiksme = '';

// Apstrādā formas iesniegšanu
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vards = trim($_POST['vards']);
    $uzvards = trim($_POST['uzvards']);
    $epasts = trim($_POST['epasts']);
    $telefons = trim($_POST['telefons']);
    $loma = $_POST['loma'];
    $aktivizets = isset($_POST['aktivizets']) ? 1 : 0;
    
    // Validācija
    if (empty($vards) || empty($uzvards) || empty($epasts)) {
        $kļūda = "Lūdzu, aizpildiet visus obligātos laukus!";
    } elseif (!filter_var($epasts, FILTER_VALIDATE_EMAIL)) {
        $kļūda = "Lūdzu, ievadiet derīgu e-pasta adresi!";
    } else {
        // Pārbauda, vai e-pasts jau eksistē citam lietotājam
        $epastaParbaude = $db->izpilditVaicajumu(
            "SELECT id FROM lietotaji WHERE epasts = ? AND id != ?",
            [$epasts, $lietotaja_id]
        );
        
        if ($epastaParbaude->rowCount() > 0) {
            $kļūda = "E-pasts jau ir reģistrēts citam lietotājam!";
        } else {
            // Atjaunina lietotāja datus
            try {
                $db->izpilditVaicajumu(
                    "UPDATE lietotaji SET vards = ?, uzvards = ?, epasts = ?, telefons = ?, loma = ?, aktivizets = ? WHERE id = ?",
                    [$vards, $uzvards, $epasts, $telefons, $loma, $aktivizets, $lietotaja_id]
                );
                
                $_SESSION['veiksme'] = "Lietotāja dati veiksmīgi atjaunināti!";
                header("Location: lietotaji.php");
                exit();
                
            } catch (Exception $e) {
                $kļūda = "Kļūda atjauninot lietotāja datus: " . $e->getMessage();
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rediģēt Lietotāju - Admin Panelis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="#">💪 Sporta Zāle - Admin</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="index.php">Panelis</a>
                <a class="nav-link" href="lietotaji.php">Lietotāji</a>
                <a class="nav-link" href="../dashboard.php">Dashboard</a>
                <a class="nav-link" href="../includes/izlogoties.php">Izlogoties</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1>Rediģēt Lietotāju</h1>
            <a href="lietotaji.php" class="btn btn-secondary">Atpakaļ</a>
        </div>

        <?php if ($kļūda): ?>
            <div class="alert alert-danger"><?php echo $kļūda; ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <form method="POST" action="">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="vards" class="form-label">Vārds *</label>
                            <input type="text" class="form-control" id="vards" name="vards" 
                                   value="<?php echo htmlspecialchars($lietotajs['vards']); ?>" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="uzvards" class="form-label">Uzvārds *</label>
                            <input type="text" class="form-control" id="uzvards" name="uzvards"
                                   value="<?php echo htmlspecialchars($lietotajs['uzvards']); ?>" required>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="epasts" class="form-label">E-pasts *</label>
                        <input type="email" class="form-control" id="epasts" name="epasts"
                               value="<?php echo htmlspecialchars($lietotajs['epasts']); ?>" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="telefons" class="form-label">Telefons</label>
                        <input type="tel" class="form-control" id="telefons" name="telefons"
                               value="<?php echo htmlspecialchars($lietotajs['telefons'] ?? ''); ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="loma" class="form-label">Loma *</label>
                        <select class="form-control" id="loma" name="loma" required>
                            <option value="klients" <?php echo $lietotajs['loma'] == 'klients' ? 'selected' : ''; ?>>Klients</option>
                            <option value="treneris" <?php echo $lietotajs['loma'] == 'treneris' ? 'selected' : ''; ?>>Treneris</option>
                            <option value="administrators" <?php echo $lietotajs['loma'] == 'administrators' ? 'selected' : ''; ?>>Administrators</option>
                        </select>
                    </div>
                    
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="aktivizets" name="aktivizets" 
                               <?php echo $lietotajs['aktivizets'] ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="aktivizets">Konts aktivizēts</label>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="lietotaji.php" class="btn btn-secondary me-md-2">Atcelt</a>
                        <button type="submit" class="btn btn-primary">Saglabāt izmaiņas</button>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- Papildus informācija -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Statistika</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Reģistrācijas datums:</strong> <?php echo date('d.m.Y H:i', strtotime($lietotajs['izveidots'])); ?></p>
                        <p><strong>Pēdējā pieslēgšanās:</strong> 
                            <?php echo $lietotajs['pedeja_pierakstisanas'] ? date('d.m.Y H:i', strtotime($lietotajs['pedeja_pierakstisanas'])) : 'Vēl nav pieslēdzies'; ?>
                        </p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Konta ID:</strong> <?php echo $lietotajs['id']; ?></p>
                        <p><strong>Pieslēgšanās skaits:</strong> 
                            <span class="badge bg-primary"><?php echo $lietotajs['pierakstisanas_skaititajs']; ?> reizes</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>