<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

$auth = new Auth();

// Pārbaude vai ir administrators
if (!$auth->isLoggedIn() || !$auth->hasRole('administrators')) {
    header("Location: ../index.php");
    exit();
}

$db = Database::getInstance();

// Apstrādāt formas iesniegšanu
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nosaukums = trim($_POST['nosaukums']);
    $apraksts = trim($_POST['apraksts']);
    $daudzums = intval($_POST['daudzums']);
    $stavoklis = $_POST['stavoklis'];
    
    // Validācija
    if (empty($nosaukums) || $daudzums < 0) {
        $error = "Lūdzu aizpildiet visus obligātos laukus!";
    } else {
        try {
            $db->izpilditVaicajumu(
                "INSERT INTO inventars (nosaukums, apraksts, daudzums, stavoklis, pirkuma_datums) VALUES (?, ?, ?, ?, NOW())",
                [$nosaukums, $apraksts, $daudzums, $stavoklis]
            );
            
            // VEIKSMĪGA PĀRADRESĀCIJA
            header("Location: inventars.php?success=1");
            exit();
            
        } catch (Exception $e) {
            $error = "Kļūda pievienojot inventāru!";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pievienot inventāru - Admin Panelis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .navbar-brand { font-weight: bold; }
    </style>
</head>
<body>
    <!-- NAVIGĀCIJA -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">💪 Sporta Zāle - Admin</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="index.php">Panelis</a>
                <a class="nav-link" href="inventars.php">Inventārs</a>
                <a class="nav-link" href="../includes/izlogoties.php">Izlogoties</a>
            </div>
        </div>
    </nav>

    <!-- SATURS -->
    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-success text-white">
                        <h5 class="card-title mb-0">➕ Pievienot jaunu inventāru</h5>
                    </div>
                    <div class="card-body">
                        <!-- KĻŪDU ZIŅOJUMI -->
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger"><?php echo $error; ?></div>
                        <?php endif; ?>

                        <!-- FORMA -->
                        <form method="POST">
                            <div class="mb-3">
                                <label for="nosaukums" class="form-label">Nosaukums *</label>
                                <input type="text" class="form-control" id="nosaukums" name="nosaukums" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="apraksts" class="form-label">Apraksts</label>
                                <textarea class="form-control" id="apraksts" name="apraksts" rows="3" placeholder="Ierakstiet inventāra aprakstu..."></textarea>
                            </div>
                            
                            <div class="mb-3">
                                <label for="daudzums" class="form-label">Daudzums *</label>
                                <input type="number" class="form-control" id="daudzums" name="daudzums" value="1" min="1" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="stavoklis" class="form-label">Stāvoklis *</label>
                                <select class="form-select" id="stavoklis" name="stavoklis" required>
                                    <option value="labā stāvoklī">Labā stāvoklī</option>
                                    <option value="jāremontē">Jāremontē</option>
                                    <option value="nolietots">Nolietots</option>
                                </select>
                            </div>
                            
                            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                <a href="inventars.php" class="btn btn-secondary me-md-2">❌ Atcelt</a>
                                <button type="submit" class="btn btn-success">✅ Pievienot inventāru</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>