<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('administrators')) {
    header("Location: ../index.php");
    exit();
}

$db = Database::getInstance();

// Maksājumu statistika
$kopējie_ieņēmumi = $db->izpilditVaicajumu(
    "SELECT SUM(summa) as total FROM maksajumi WHERE stavoklis = 'apmaksāts'"
)->fetch()['total'] ?? 0;

$gaida_maksajumu = $db->izpilditVaicajumu(
    "SELECT COUNT(*) as skaits FROM maksajumi WHERE stavoklis = 'gaida'"
)->fetch()['skaits'];

// Maksājumu saraksts
$maksajumi = $db->izpilditVaicajumu("
    SELECT m.*, l.vards, l.uzvards, l.epasts 
    FROM maksajumi m 
    LEFT JOIN lietotaji l ON m.lietotaja_id = l.id 
    ORDER BY m.maksajuma_datums DESC
")->fetchAll();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Maksājumi - Admin Panelis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="#">💪 Sporta Zāle - Admin</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="index.php">Panelis</a>
                <a class="nav-link" href="../dashboard.php">Dashboard</a>
                <a class="nav-link" href="../includes/izlogoties.php">Izlogoties</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h1>Maksājumu Pārvaldība</h1>
        
        <!-- Statistika -->
        <div class="row mt-4">
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <h5 class="card-title">Kopējie ieņēmumi</h5>
                        <p class="card-text display-6"><?php echo number_format($kopējie_ieņēmumi, 2); ?> €</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-warning">
                    <div class="card-body">
                        <h5 class="card-title">Gaidāmie maksājumi</h5>
                        <p class="card-text display-6"><?php echo $gaida_maksajumu; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-info">
                    <div class="card-body">
                        <h5 class="card-title">Kopējie maksājumi</h5>
                        <p class="card-text display-6"><?php echo count($maksajumi); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Maksājumu saraksts -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Visi maksājumi</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Klients</th>
                                <th>Summa</th>
                                <th>Datums</th>
                                <th>Veids</th>
                                <th>Statuss</th>
                                <th>Abonements</th>
                                <th>Darbības</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($maksajumi as $maksajums): ?>
                                <tr>
                                    <td><?php echo $maksajums['id']; ?></td>
                                    <td>
                                        <?php echo htmlspecialchars($maksajums['vards'] . ' ' . $maksajums['uzvards']); ?><br>
                                        <small class="text-muted"><?php echo htmlspecialchars($maksajums['epasts']); ?></small>
                                    </td>
                                    <td><?php echo number_format($maksajums['summa'], 2); ?> €</td>
                                    <td><?php echo date('d.m.Y H:i', strtotime($maksajums['maksajuma_datums'])); ?></td>
                                    <td>
                                        <span class="badge bg-secondary"><?php echo $maksajums['veids']; ?></span>
                                    </td>
                                    <td>
                                        <span class="badge 
                                            <?php echo $maksajums['stavoklis'] == 'apmaksāts' ? 'bg-success' : 
                                                   ($maksajums['stavoklis'] == 'gaida' ? 'bg-warning' : 'bg-danger'); ?>">
                                            <?php echo $maksajums['stavoklis']; ?>
                                        </span>
                                    </td>
                                    <td><?php echo $maksajums['abonementa_veids'] ?: '-'; ?></td>
                                    <td>
                                        <?php if ($maksajums['stavoklis'] == 'gaida'): ?>
                                            <a href="maksajumi.php?apstiprinat=<?php echo $maksajums['id']; ?>" 
                                               class="btn btn-success btn-sm"
                                               onclick="return confirm('Apstiprināt maksājumu?')">
                                                Apstiprināt
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>