<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('administrators')) {
    header("Location: ../index.php");
    exit();
}

$db = Database::getInstance();

// Lietotāju dzēšana
if (isset($_GET['dzest']) && is_numeric($_GET['dzest'])) {
    $dzest_id = $_GET['dzest'];
    $db->izpilditVaicajumu("DELETE FROM lietotaji WHERE id = ? AND loma != 'administrators'", [$dzest_id]);
    $_SESSION['veiksme'] = "Lietotājs veiksmīgi dzēsts!";
    header("Location: lietotaji.php");
    exit();
}

// Lietotāju iegūšana AR SKAITĪTĀJU
$lietotaji = $db->izpilditVaicajumu("
    SELECT id, vards, uzvards, epasts, loma, telefons, aktivizets, 
           pierakstisanas_skaititajs, pedeja_pierakstisanas, izveidots 
    FROM lietotaji 
    ORDER BY izveidots DESC
")->fetchAll();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lietotāji - Admin Panelis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="#">💪 Sporta Zāle - Admin</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="index.php">Panelis</a>
                <a class="nav-link" href="../dashboard.php">Dashboard</a>
                <a class="nav-link" href="../includes/izlogoties.php">Izlogoties</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1>Lietotāju Pārvaldība</h1>
            <a href="pievienot_lietotaju.php" class="btn btn-success">Pievienot jaunu lietotāju</a>
        </div>

        <?php if (isset($_SESSION['veiksme'])): ?>
            <div class="alert alert-success"><?php echo $_SESSION['veiksme']; unset($_SESSION['veiksme']); ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Vārds</th>
                                <th>Uzvārds</th>
                                <th>E-pasts</th>
                                <th>Loma</th>
                                <th>Telefons</th>
                                <th>Pieslēgšanās</th>
                                <th>Pēdējā piesl.</th>
                                <th>Statuss</th>
                                <th>Reģistrējies</th>
                                <th>Darbības</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($lietotaji as $lietotajs): ?>
                                <tr>
                                    <td><?php echo $lietotajs['id']; ?></td>
                                    <td><?php echo htmlspecialchars($lietotajs['vards']); ?></td>
                                    <td><?php echo htmlspecialchars($lietotajs['uzvards']); ?></td>
                                    <td><?php echo htmlspecialchars($lietotajs['epasts']); ?></td>
                                    <td>
                                        <span class="badge 
                                            <?php echo $lietotajs['loma'] == 'administrators' ? 'bg-danger' : 
                                                   ($lietotajs['loma'] == 'treneris' ? 'bg-success' : 'bg-info'); ?>">
                                            <?php echo $lietotajs['loma']; ?>
                                        </span>
                                    </td>
                                    <td><?php echo $lietotajs['telefons'] ?: 'Nav norādīts'; ?></td>
                                    <td>
                                        <span class="badge bg-secondary">
                                            <?php echo $lietotajs['pierakstisanas_skaititajs']; ?> reizes
                                        </span>
                                    </td>
                                    <td>
                                        <?php if ($lietotajs['pedeja_pierakstisanas']): ?>
                                            <small><?php echo date('d.m.Y H:i', strtotime($lietotajs['pedeja_pierakstisanas'])); ?></small>
                                        <?php else: ?>
                                            <small class="text-muted">Vēl nav</small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge <?php echo $lietotajs['aktivizets'] ? 'bg-success' : 'bg-secondary'; ?>">
                                            <?php echo $lietotajs['aktivizets'] ? 'Aktīvs' : 'Deaktivizēts'; ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('d.m.Y H:i', strtotime($lietotajs['izveidots'])); ?></td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="rediget_lietotaju.php?id=<?php echo $lietotajs['id']; ?>" class="btn btn-outline-primary">Rediģēt</a>
                                            <?php if ($lietotajs['loma'] != 'administrators'): ?>
                                                <a href="lietotaji.php?dzest=<?php echo $lietotajs['id']; ?>" 
                                                   class="btn btn-outline-danger" 
                                                   onclick="return confirm('Vai tiešām vēlaties dzēst šo lietotāju?')">
                                                    Dzēst
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>