<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('administrators')) {
    header("Location: ../index.php");
    exit();
}

$db = Database::getInstance();

// Dzēšanas funkcija
if (isset($_GET['dzest'])) {
    $id = intval($_GET['dzest']);
    
    // Pārbaudīt vai inventārs eksistē
    $check = $db->izpilditVaicajumu("SELECT * FROM inventars WHERE id = ?", [$id]);
    if ($check->fetch()) {
        // Dzēst inventāru
        $db->izpilditVaicajumu("DELETE FROM inventars WHERE id = ?", [$id]);
        header("Location: inventars.php?success=3");
        exit();
    } else {
        header("Location: inventars.php?error=1");
        exit();
    }
}

// Veiksmes ziņojumi
$success_message = '';
if (isset($_GET['success'])) {
    switch ($_GET['success']) {
        case '1': $success_message = 'Inventārs veiksmīgi pievienots!'; break;
        case '2': $success_message = 'Inventārs veiksmīgi rediģēts!'; break;
        case '3': $success_message = 'Inventārs veiksmīgi dzēsts!'; break;
    }
}

// Inventāra statistika
$kopais_inventars = $db->izpilditVaicajumu("SELECT COUNT(*) as skaits FROM inventars")->fetch()['skaits'];
$labā_stāvoklī = $db->izpilditVaicajumu("SELECT COUNT(*) as skaits FROM inventars WHERE stavoklis = 'labā stāvoklī'")->fetch()['skaits'];
$jāremontē = $db->izpilditVaicajumu("SELECT COUNT(*) as skaits FROM inventars WHERE stavoklis = 'jāremontē'")->fetch()['skaits'];

// Inventāra saraksts
$inventars = $db->izpilditVaicajumu("SELECT * FROM inventars ORDER BY izveidots DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inventārs - Admin Panelis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="#">💪 Sporta Zāle - Admin</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="index.php">Panelis</a>
                <a class="nav-link" href="../dashboard.php">Dashboard</a>
                <a class="nav-link" href="../includes/izlogoties.php">Izlogoties</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1>Inventāra Pārvaldība</h1>
            <a href="pievienot_inventaru.php" class="btn btn-success">Pievienot jaunu inventāru</a>
        </div>

        <!-- Veiksmes ziņojumi -->
        <?php if (!empty($success_message)): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo $success_message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Kļūdu ziņojumi -->
        <?php if (isset($_GET['error'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                Kļūda dzēšot inventāru!
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Statistika -->
        <div class="row mt-4">
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <h5 class="card-title">Kopējais inventārs</h5>
                        <p class="card-text display-6"><?php echo $kopais_inventars; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <h5 class="card-title">Labā stāvoklī</h5>
                        <p class="card-text display-6"><?php echo $labā_stāvoklī; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-warning">
                    <div class="card-body">
                        <h5 class="card-title">Jāremontē</h5>
                        <p class="card-text display-6"><?php echo $jāremontē; ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Inventāra saraksts -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Inventāra saraksts</h5>
            </div>
            <div class="card-body">
                <?php if (empty($inventars)): ?>
                    <div class="alert alert-info">
                        Nav pievienots neviens inventāra priekšmets.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Nosaukums</th>
                                    <th>Apraksts</th>
                                    <th>Daudzums</th>
                                    <th>Stāvoklis</th>
                                    <th>Pirkuma datums</th>
                                    <th>Darbības</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($inventars as $items): ?>
                                    <tr>
                                        <td><?php echo $items['id']; ?></td>
                                        <td><?php echo htmlspecialchars($items['nosaukums']); ?></td>
                                        <td><?php echo htmlspecialchars($items['apraksts']); ?></td>
                                        <td>
                                            <span class="badge bg-primary"><?php echo $items['daudzums']; ?></span>
                                        </td>
                                        <td>
                                            <span class="badge 
                                                <?php echo $items['stavoklis'] == 'labā stāvoklī' ? 'bg-success' : 
                                                       ($items['stavoklis'] == 'jāremontē' ? 'bg-warning' : 'bg-secondary'); ?>">
                                                <?php echo $items['stavoklis']; ?>
                                            </span>
                                        </td>
                                        <td><?php echo $items['pirkuma_datums'] ? date('d.m.Y', strtotime($items['pirkuma_datums'])) : 'Nav norādīts'; ?></td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <a href="rediget_inventaru.php?id=<?php echo $items['id']; ?>" class="btn btn-outline-primary">Rediģēt</a>
                                                <button type="button" 
                                                        class="btn btn-outline-danger" 
                                                        onclick="if(confirm('Vai tiešām dzēst <?php echo addslashes($items['nosaukums']); ?>?')) { window.location.href = 'inventars.php?dzest=<?php echo $items['id']; ?>'; }">
                                                    Dzēst
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>