<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('administrators')) {
    header("Location: ../index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();

// Statistika
$db = Database::getInstance();
$lietotaju_skaits = $db->izpilditVaicajumu("SELECT COUNT(*) as skaits FROM lietotaji")->fetch()['skaits'];
$treneru_skaits = $db->izpilditVaicajumu("SELECT COUNT(*) as skaits FROM lietotaji WHERE loma = 'treneris'")->fetch()['skaits'];
$klientu_skaits = $db->izpilditVaicajumu("SELECT COUNT(*) as skaits FROM lietotaji WHERE loma = 'klients'")->fetch()['skaits'];
$nodarbibu_skaits = $db->izpilditVaicajumu("SELECT COUNT(*) as skaits FROM nodarbibas WHERE sakuma_laiks > NOW()")->fetch()['skaits'];
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panelis - Sporta Zāle</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="#">💪 Sporta Zāle - Admin</a>
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3">
                    Sveiks, <?php echo htmlspecialchars($lietotajs['vards']); ?>!
                </span>
                <a class="nav-link" href="../dashboard.php">Dashboard</a>
                <a class="nav-link" href="../includes/izlogoties.php">Izlogoties</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h1>Administratora Panelis</h1>
        
        <!-- Statistika -->
        <div class="row mt-4">
            <div class="col-md-3 mb-3">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <h5 class="card-title">Kopējais lietotāju skaits</h5>
                        <p class="card-text display-6"><?php echo $lietotaju_skaits; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <h5 class="card-title">Treneru skaits</h5>
                        <p class="card-text display-6"><?php echo $treneru_skaits; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card text-white bg-info">
                    <div class="card-body">
                        <h5 class="card-title">Klientu skaits</h5>
                        <p class="card-text display-6"><?php echo $klientu_skaits; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card text-white bg-warning">
                    <div class="card-body">
                        <h5 class="card-title">Gaidāmās nodarbības</h5>
                        <p class="card-text display-6"><?php echo $nodarbibu_skaits; ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Ātrās darbības -->
        <div class="row mt-4">
            <div class="col-12">
                <h3>Ātrās darbības</h3>
                <div class="row mt-3">
                    <div class="col-md-2 mb-2">
                        <a href="lietotaji.php" class="btn btn-outline-primary w-100">Lietotāji</a>
                    </div>
                    <div class="col-md-2 mb-2">
                        <a href="nodarbibas.php" class="btn btn-outline-success w-100">Nodarbības</a>
                    </div>
                    <div class="col-md-2 mb-2">
                        <a href="maksajumi.php" class="btn btn-outline-info w-100">Maksājumi</a>
                    </div>
                    <div class="col-md-2 mb-2">
                        <a href="inventars.php" class="btn btn-outline-warning w-100">Inventārs</a>
                    </div>
                    <div class="col-md-2 mb-2">
                        <a href="../dashboard.php" class="btn btn-outline-secondary w-100">Dashboard</a>
                    </div>
                    <div class="col-md-2 mb-2">
                        <a href="../includes/izlogoties.php" class="btn btn-outline-danger w-100">Izlogoties</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>