-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.4.32-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             12.14.0.7165
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dumping database structure for sporta_zale
DROP DATABASE IF EXISTS `sporta_zale`;
CREATE DATABASE IF NOT EXISTS `sporta_zale` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci */;
USE `sporta_zale`;

-- Dumping structure for table sporta_zale.atjauninas_token
DROP TABLE IF EXISTS `atjauninas_token`;
CREATE TABLE IF NOT EXISTS `atjauninas_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls token ID',
  `lietotaja_id` int(11) NOT NULL COMMENT 'Atsauce uz lietotāju (lietotaji.id)',
  `token` varchar(255) NOT NULL COMMENT 'Unikāls atjaunošanas tokens',
  `izveidots` datetime DEFAULT current_timestamp() COMMENT 'Token izveides laiks',
  `derigs_lidz` datetime NOT NULL COMMENT 'Token derīguma termiņš',
  `izmantots` tinyint(1) DEFAULT 0 COMMENT 'Vai tokens jau izmantots (TRUE/FALSE)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_token` (`token`),
  KEY `idx_derigs_lidz` (`derigs_lidz`),
  KEY `idx_lietotaja_token` (`lietotaja_id`,`token`),
  CONSTRAINT `atjauninas_token_ibfk_1` FOREIGN KEY (`lietotaja_id`) REFERENCES `lietotaji` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Paroles atjaunošanas tokenu tabula';

-- Data exporting was unselected.

-- Dumping structure for table sporta_zale.inventars
DROP TABLE IF EXISTS `inventars`;
CREATE TABLE IF NOT EXISTS `inventars` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls inventāra ID',
  `nosaukums` varchar(100) NOT NULL COMMENT 'Inventāra vienības nosaukums',
  `apraksts` text DEFAULT NULL COMMENT 'Detalizēts apraksts',
  `daudzums` int(11) DEFAULT 1 COMMENT 'Pieejamais daudzums',
  `stavoklis` enum('labā stāvoklī','jāremontē','nolietots') DEFAULT 'labā stāvoklī' COMMENT 'Inventāra stāvoklis',
  `pirkuma_datums` date DEFAULT NULL COMMENT 'Pirkuma datums',
  `izveidots` datetime DEFAULT current_timestamp() COMMENT 'Ieraksta izveides laiks',
  PRIMARY KEY (`id`),
  KEY `idx_stavoklis` (`stavoklis`),
  KEY `idx_nosaukums` (`nosaukums`),
  KEY `idx_inventars_stavokli` (`stavoklis`,`pirkuma_datums`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Sporta inventāra uzskaites tabula';

-- Data exporting was unselected.

-- Dumping structure for table sporta_zale.lietotaji
DROP TABLE IF EXISTS `lietotaji`;
CREATE TABLE IF NOT EXISTS `lietotaji` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls lietotāja identifikators',
  `vards` varchar(50) NOT NULL COMMENT 'Lietotāja vārds',
  `uzvards` varchar(50) NOT NULL COMMENT 'Lietotāja uzvārds',
  `epasts` varchar(100) NOT NULL COMMENT 'Unikāla e-pasta adrese',
  `parole` varchar(255) NOT NULL COMMENT 'Hash-ota parole',
  `loma` enum('administrators','treneris','klients') DEFAULT 'klients' COMMENT 'Lietotāja loma sistēmā',
  `telefons` varchar(20) DEFAULT NULL COMMENT 'Kontakttelefons',
  `dzimsanas_datums` date DEFAULT NULL COMMENT 'Dzimšanas datums',
  `profila_bilde` varchar(255) DEFAULT NULL COMMENT 'Profila attēla ceļš',
  `aktivizets` tinyint(1) DEFAULT 1 COMMENT 'Vai konts ir aktīvs (TRUE/FALSE)',
  `pierakstisanas_skaititajs` int(11) DEFAULT 0 COMMENT 'Veikto pierakstīšanās skaits',
  `pedeja_pierakstisanas` datetime DEFAULT NULL COMMENT 'Pēdējās pierakstīšanās laiks',
  `izveidots` datetime DEFAULT current_timestamp() COMMENT 'Konta izveides laiks',
  `atjauninats` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Pēdējā atjaunošanas laiks',
  PRIMARY KEY (`id`),
  UNIQUE KEY `epasts` (`epasts`),
  KEY `idx_lietotaji_epasts` (`epasts`),
  KEY `idx_lietotaji_loma` (`loma`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Sistēmas lietotāju tabula (administratori, treneri, klienti)';

-- Data exporting was unselected.

-- Dumping structure for table sporta_zale.maksajumi
DROP TABLE IF EXISTS `maksajumi`;
CREATE TABLE IF NOT EXISTS `maksajumi` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls maksājuma ID',
  `lietotaja_id` int(11) NOT NULL COMMENT 'Atsauce uz lietotāju (lietotaji.id)',
  `summa` decimal(10,2) NOT NULL COMMENT 'Maksājuma summa',
  `maksajuma_datums` datetime DEFAULT current_timestamp() COMMENT 'Maksājuma datums un laiks',
  `veids` enum('abonements','nodarbība','cits') DEFAULT 'abonements' COMMENT 'Maksājuma veids',
  `stavoklis` enum('apmaksāts','gaida','atcelts') DEFAULT 'gaida' COMMENT 'Maksājuma statuss',
  `abonementa_veids` varchar(50) DEFAULT NULL COMMENT 'Abonementa veida nosaukums',
  `deriguma_termins` date DEFAULT NULL COMMENT 'Abonementa derīguma termiņš',
  PRIMARY KEY (`id`),
  KEY `idx_maksajuma_datums` (`maksajuma_datums`),
  KEY `idx_stavoklis` (`stavoklis`),
  KEY `idx_deriguma_termins` (`deriguma_termins`),
  KEY `idx_maksajumi_lietotajs` (`lietotaja_id`,`maksajuma_datums`),
  CONSTRAINT `maksajumi_ibfk_1` FOREIGN KEY (`lietotaja_id`) REFERENCES `lietotaji` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maksājumu un abonementu pārvaldības tabula';

-- Data exporting was unselected.

-- Dumping structure for table sporta_zale.nodarbibas
DROP TABLE IF EXISTS `nodarbibas`;
CREATE TABLE IF NOT EXISTS `nodarbibas` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls nodarbības ID',
  `nosaukums` varchar(100) NOT NULL COMMENT 'Nodarbības nosaukums',
  `apraksts` text DEFAULT NULL COMMENT 'Detalizēts nodarbības apraksts',
  `treneris_id` int(11) NOT NULL COMMENT 'Atsauce uz treneri (lietotaji.id)',
  `sakuma_laiks` datetime NOT NULL COMMENT 'Nodarbības sākuma laiks',
  `beigu_laiks` datetime NOT NULL COMMENT 'Nodarbības beigu laiks',
  `maksimalais_dalibnieku_skaits` int(11) DEFAULT 20 COMMENT 'Maksimālais dalībnieku skaits',
  `stavoklis` enum('aktīva','atcelta','pabeigta') DEFAULT 'aktīva' COMMENT 'Nodarbības pašreizējais statuss',
  `izveidots` datetime DEFAULT current_timestamp() COMMENT 'Ieraksta izveides laiks',
  PRIMARY KEY (`id`),
  KEY `idx_sakuma_laiks` (`sakuma_laiks`),
  KEY `idx_stavoklis` (`stavoklis`),
  KEY `idx_nodarbibas_treneris` (`treneris_id`),
  KEY `idx_nodarbibas_laiks` (`sakuma_laiks`,`beigu_laiks`),
  CONSTRAINT `nodarbibas_ibfk_1` FOREIGN KEY (`treneris_id`) REFERENCES `lietotaji` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Treniņu nodarbību grafika tabula';

-- Data exporting was unselected.

-- Dumping structure for table sporta_zale.pieraksti
DROP TABLE IF EXISTS `pieraksti`;
CREATE TABLE IF NOT EXISTS `pieraksti` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls pieraksta ID',
  `lietotaja_id` int(11) NOT NULL COMMENT 'Atsauce uz klientu (lietotaji.id)',
  `nodarbibas_id` int(11) NOT NULL COMMENT 'Atsauce uz nodarbību (nodarbibas.id)',
  `pieraksta_datums` datetime DEFAULT current_timestamp() COMMENT 'Pierakstīšanās datums un laiks',
  `stavoklis` enum('apstiprināts','atcelts','pabeigts') DEFAULT 'apstiprināts' COMMENT 'Pieraksta statuss',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_pieraksts` (`lietotaja_id`,`nodarbibas_id`) COMMENT 'Novērš dubultpierakstus',
  KEY `idx_stavoklis` (`stavoklis`),
  KEY `idx_lietotaja` (`lietotaja_id`),
  KEY `nodarbibas_id` (`nodarbibas_id`),
  KEY `idx_pieraksti_datumu` (`pieraksta_datums`),
  CONSTRAINT `pieraksti_ibfk_1` FOREIGN KEY (`lietotaja_id`) REFERENCES `lietotaji` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pieraksti_ibfk_2` FOREIGN KEY (`nodarbibas_id`) REFERENCES `nodarbibas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Klientu pierakstu uz nodarbībām tabula';

-- Data exporting was unselected.

-- Dumping structure for table sporta_zale.treninu_plani
DROP TABLE IF EXISTS `treninu_plani`;
CREATE TABLE IF NOT EXISTS `treninu_plani` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls plāna ID',
  `lietotaja_id` int(11) NOT NULL COMMENT 'Atsauce uz klientu (lietotaji.id)',
  `treneris_id` int(11) DEFAULT NULL COMMENT 'Atsauce uz treneri (lietotaji.id)',
  `nosaukums` varchar(100) NOT NULL COMMENT 'Treniņu plāna nosaukums',
  `apraksts` text DEFAULT NULL COMMENT 'Plāna apraksts un instrukcijas',
  `izveidots` datetime DEFAULT current_timestamp() COMMENT 'Plāna izveides laiks',
  `beigu_datums` date DEFAULT NULL COMMENT 'Plāna beigu datums',
  PRIMARY KEY (`id`),
  KEY `idx_beigu_datums` (`beigu_datums`),
  KEY `lietotaja_id` (`lietotaja_id`),
  KEY `treneris_id` (`treneris_id`),
  CONSTRAINT `treninu_plani_ibfk_1` FOREIGN KEY (`lietotaja_id`) REFERENCES `lietotaji` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `treninu_plani_ibfk_2` FOREIGN KEY (`treneris_id`) REFERENCES `lietotaji` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Individuālo treniņu plānu tabula';

-- Data exporting was unselected.

-- Dumping structure for table sporta_zale.zurnals
DROP TABLE IF EXISTS `zurnals`;
CREATE TABLE IF NOT EXISTS `zurnals` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls žurnāla ieraksta ID',
  `lietotaja_id` int(11) DEFAULT NULL COMMENT 'Atsauce uz lietotāju (lietotaji.id)',
  `darbiba` varchar(100) NOT NULL COMMENT 'Veiktā darbība',
  `datums` datetime DEFAULT current_timestamp() COMMENT 'Darbības datums un laiks',
  `ip_adrese` varchar(45) DEFAULT NULL COMMENT 'Lietotāja IP adrese',
  PRIMARY KEY (`id`),
  KEY `idx_datums` (`datums`),
  KEY `idx_lietotaja_darbiba` (`lietotaja_id`,`darbiba`),
  KEY `idx_zurnals_lietotajs` (`lietotaja_id`,`datums`),
  CONSTRAINT `zurnals_ibfk_1` FOREIGN KEY (`lietotaja_id`) REFERENCES `lietotaji` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Sistēmas darbību žurnāla tabula';

-- Data exporting was unselected.

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
