/*
    Created: 2025-11-05
    Author: Kārlis Grīnvalds
    Last edited: 2025-11-05
    Edited by: Kārlis Grīnvalds
*/

// Used for view_file.html

// Checks user's session data
async function UserBar(hasSession) {
    // Doesn't have anything
}

// Runs all the needed functions for the current page
async function Load() {
    // Gets the url parameter
    const fileName = window.location.href.split("?file=")[1];
    // Gets the user's entry data and displays it on the page
    console.log(fileName);
    await $.ajax({
        url: "/file/" + fileName,
        method: "GET",
        success: async function(response) {
            // If no entry was found then user gets taken to error 404 page
            if (response.length <= 0) {
                Link("/error/404");
            }
            $("#FileDisplayName").text("File:" + fileName);
            $("#FileDescription").append("<h2>" + response[0].title + "</h2>");
            switch (fileName.split(".")[1]) {
                case "gif":
                case "jpeg":
                case "jpg":
                case "png":
                case "webp":
                    $("#FileDescription").append("<img src=\"/" + Topic() + "/load/" + fileName + "\">");
                    break;
                case "mp3":
                case "wav":
                    $("#FileDescription").append("<audio controls><source src=\"/" + Topic() + "/laod/" + fileName + "\"></audio>");
                    break;
                default:
                    $("#FileDescription").append("Not supported");
                    break;
            }
            $("#FileDescription").append("<br>" + response[0].description);
            $("#EntryTitle").text(response[0].title);
            $("footer").append("Uploaded: " + response[0].created_at);
            if (response[0].edited_at != null) {
                // If the entry has been edited then this will also get displayed
                $("footer").append("<br>Last edited: " + response[0].edited_at);
            }
        }
    });
}