/*
    Created: 2025-02-27
    Author: Kārlis Grīnvalds
    Last edited: 2025-09-13
    Edited by: Kārlis Grīnvalds
*/

// Used for view_entry.html

// Checks user's session data
async function UserBar(hasSession) {
    // Doesn't have anything
}

// Runs all the needed functions for the current page
async function Load() {
    // Gets the url parameter
    const entryId = window.location.href.split("?entry=")[1];
    // Gets the user's entry data and displays it on the page
    await $.ajax({
        url: "/entry/" + entryId,
        method: "GET",
        success: async function(response) {
            // If no entry was found then user gets taken to error 404 page
            if (response.length <= 0) {
                Link("/error/404");
            }
            $("#EntryTitle").text(response[0].title);
            $("footer").append("Created at: " + response[0].created_at);
            if (response[0].edited_at != null) {
                // If the entry has been edited then this will also get displayed
                $("footer").append("<br>Last edited: " + response[0].edited_at);
            }
            $("#EntryContent").append(response[0].content);
            CreateContentList(response[0].content);
            // Checks if the user can edit the entry
            await $.ajax({
                url: "/entry/permission/" + response[0].id,
                method: "GET",
                success: function(answer) {
                    if (answer) {
                        $("#UserActionBar").append("<a href=\"/" + Topic() + "/entry/edit?entry=" + entryId + "\">Edit</a>");
                    }
                }
            });
        }
    });
}

// Fills the content list with links to sections
function CreateContentList(entryContent) {
    // Creates array without "<", ">" from the entry's content
    let array = entryContent.split("<");
    let newArray = [];
    for(let _ in array) {
        let arr = array[_].split(">");
        newArray.push(arr[0]);
        newArray.push(arr[1]);
    }
    // Finds all the headings and gives them id for links
    let obj = $("#EntryContent").find("h2");
    for(let _ = 0; _ < obj["length"]; _++) {
        $(obj[_]).attr("id", "section-" + (_ + 1));
    }
    obj = $("#EntryContent").find("h3");
    for(let _ = 0; _ < obj["length"]; _++) {
        $(obj[_]).attr("id", "subsection-" + (_ + 1));
    }
    obj = $("#EntryContent").find("h4");
    for(let _ = 0; _ < obj["length"]; _++) {
        $(obj[_]).attr("id", "subsubsection-" + (_ + 1));
    }
    // Adds all sections to the content list with links to each section
    let sectionCount = [0, 0, 0];
    let subSectionRepeatNumber = [0, 1];
    for(let _ in newArray) {
        addToList = false;
        switch(newArray[_]) {
            case "h2":
                sectionCount[0]++;
                $("#ContentList").append("<li class=\"section\"><a href=\"#section-" + sectionCount[0] + "\">" + sectionCount[0] + ". " + newArray[parseInt(_) + 1] + "</a></li>");
                subSectionRepeatNumber = [0, 1];
                break;
            case "h3":
                sectionCount[1]++;
                subSectionRepeatNumber[0]++;
                subSectionRepeatNumber[1] = 1;
                $("#ContentList").append("<li class=\"subsection\"><a href=\"#subsection-" + sectionCount[1] + "\">" + sectionCount[0] + "." + subSectionRepeatNumber[0] + ". " + newArray[parseInt(_) + 1] + "</a></li>");
                break;
            case "h4":
                sectionCount[2]++;
                $("#ContentList").append("<li class=\"subsubsection\"><a href=\"#subsubsection-" + sectionCount[2] + "\">" + sectionCount[0] + "." + subSectionRepeatNumber[0] + "." + subSectionRepeatNumber[1] + ". " + newArray[parseInt(_) + 1] + "</a></li>");
                subSectionRepeatNumber[1]++;
                break;
        }
    }
    // If there were no headings/section in the content list then the list gets removed
    if ($("#ContentList")[0].childElementCount == 0) {
        $("#ContentListContainer").remove();
    }
}