/*
    Created: 2025-02-27
    Author: Kārlis Grīnvalds
    Last edited: 2025-09-17
    Edited by: Kārlis Grīnvalds
*/

// Used for search.html

// Checks user's session data
async function UserBar(hasSession) {
    // Doesn't have anything
}

// Finds entries with the same character combination as the url parameter
async function Load() {
    // Gets the url parameter
    const searched = window.location.href.split("?find=")[1];
    await $.ajax({
        url: "/" + Topic() + "/entry/find",
        method: "GET",
        data: {param: decodeURI(searched).toLowerCase()},
        success: function(response) {
            if (response.length > 0) {
                // If there are entries then it will output all in a table
                for (let _ = 0; _ < response.length; _++) {
                    $("#SearchResults").append("<li><a id=\"entry" + response[_].id + "\" href=\"/" + Topic() + "/view?entry=" + response[_].id + "\"></a></li>");
                    $("#entry" + response[_].id).text(String(response[_].title));
                }
            }
            else {
                // If nothing was found then this message will get shown
                $("#SearchResults").text("We could find anything with \"" + decodeURI(searched) + "\" related. :(");
            }
        },
        error: function(response) {
            // If there has been an error then it will show "Nothing found" message
            $("#SearchResults").text("We could find anything with \"" + decodeURI(searched) + "\" related. :(");
        }
    });
}