/*
    Created: 2025-09-16
    Author: Kārlis Grīnvalds
    Last edited: 2025-11-05
    Edited by: Kārlis Grīnvalds
*/

// Used for admin_panel.html

// Checks user's session data
async function UserBar(hasSession) {
    if (hasSession) {
        // Adds a links
        $("#UserActionBar").append("<a href=\"/" + Topic() + "/entry/create\">Create entry</a><a href=\"/" + Topic() + "/upload\">Upload file</a>");
    }
}

async function Load() {
    $("#TopicLink").attr("href", "/" + Topic() + "/edit");
    await $.ajax({
        url: "/entries/" + Topic(),
        method: "GET",
        success: function(response) {
            for (let _ = 0; _ < response.length; _++) {
                let appendString = "<tr><td>" + response[_].title + "</td><td>" + response[_].created_at + "</td>";
                if (response[_].edited_at != null) {
                    appendString += "<td>" + response[_].edited_at + "</td>";
                }
                else {
                    appendString += "<td> - </td>";
                }
                appendString += "<td><a href=\"/" + Topic() + "/view?entry=" + response[_].id + "\">View</a> <a href=\"/" + Topic() + "/entry/edit?entry=" + response[_].id + "\">Edit</a></td></tr>";
                $("#TableOfEntries").append(appendString);
            }
        }
    });
    await $.ajax({
        url: "/" + Topic() + "/files",
        method: "GET",
        success: async function(response) {
            for (let _ = 0; _ < response.length; _++) {
                let appendString = "<tr><td id=\"file" + response[_].id + "\"></td><td>" + response[_].name + "</td><td>" + response[_].created_at + "</td>";
                if (response[_].edited_at != null) {
                    appendString += "<td>" + response[_].edited_at + "</td>";
                }
                else {
                    appendString += "<td> - </td>";
                }
                appendString += "<td><a href=\"/" + Topic() + "/file?file=" + response[_].file + "\">View</a> <a href=\"/" + Topic() + "/main\">Edit</a></td></tr>";
                $("#TableOfFiles").append(appendString);
                switch (response[_].file.split(".")[1]) {
                    case "gif":
                    case "jpeg":
                    case "jpg":
                    case "png":
                    case "webp":
                        $("#file" + response[_].id).append("<img src=\"/" + Topic() + "/load/" + response[_].file + "\">");
                        break;
                    case "mp3":
                    case "wav":
                        $("#file" + response[_].id).append("<audio controls><source src=\"/" + Topic() + "/laod/" + response[_].file + "\"></audio>");
                        break;
                    default:
                        $("#file" + response[_].id).append("Not supported");
                        break;
                }
            }
        }
    });
}