<?php

use CodeIgniter\Router\RouteCollection;

$routes->get("entries/(:alphanum)", "EntryController::GetEntries/$1");
$routes->get("entry/(:num)", "EntryController::GetEntry/$1");
$routes->post("entry/(:num)", "EntryController::PostEntry/$1");
$routes->delete("entry/(:num)", "EntryController::DeleteEntry/$1");
$routes->get("/(:alphanum)/entry/find", "EntryController::SearchFunction/$1");
$routes->get("/entry/permission/(:num)", "EntryController::AllowToEdit/$1");

$routes->post("/user", "UserController::CreateUser");
$routes->post("/user/session", "UserController::LogInUser");
$routes->put("/user/session", "UserController::CheckSession");
$routes->get("/user/session", "UserController::EndSession");

$routes->get("/", "TransferController::Index");
$routes->get("/(:alphanum)/main", "TransferController::MainPage/$1");
$routes->get("/(:alphanum)/admin", "TransferController::AdminPanel/$1");
$routes->get("/(:alphanum)/view", "TransferController::GoToEntry");
$routes->get("/(:alphanum)/create_account", "TransferController::ViewCreateAccountPage");
$routes->get("/(:alphanum)/log_in", "TransferController::ViewLogInPage");
$routes->get("/(:alphanum)/search", "TransferController::SearchPage");
$routes->get("/(:alphanum)/entry/create", "TransferController::CreateEntry");
$routes->get("/(:alphanum)/entry/edit", "TransferController::EditEntry");
$routes->get("/(:alphanum)/edit", "TransferController::EditTopic");
$routes->get("/(:alphanum)/upload", "TransferController::FileUploadPage");
$routes->get("/(:alphanum)/file", "TransferController::FileViewPage");
$routes->get("/error/(:num)", "TransferController::ErrorPage/$1");

$routes->get("/topic/(:alphanum)", "TopicController::GetTopic/$1");
$routes->post("/topic/(:alphanum)", "TopicController::UpdateTopic/$1");

$routes->get("/(:alphanum)/files", "FilesController::GetTopicFiles/$1");
$routes->get("/(:alphanum)/load/(:any)", "FilesController::GetFile/$1/$2");
$routes->get("/file/(:any)", "FilesController::GetFileInformation/$1");
$routes->post("/file/upload", "FilesController::UploadFile");
$routes->post("/file/(:num)", "FilesController::UpdateFile/$1");

$routes->set404Override(function(){
    return view("errors/error404.html");
});