/*
    Created: 2025-09-22
    Author: Kārlis Grīnvalds
    Last edited: 2025-09-22
    Edited by: Kārlis Grīnvalds
*/

// Used for edit_topic.html

// Checks user's session data
async function UserBar(hasSession) {
    if (!hasSession) {
        // User is not allowed on this page without an open session
        Link("/error/403");
    }
}

// Shows topic data in the input field and saves any changes
async function Load() {
    // Gets topic data
    await $.ajax({
        url: "/topic/" + Topic(),
        method: "GET",
        success: function(response) {
            // If no topic was found then user gets taken to error 404 page
            if (response.length <= 0) {
                Link("/error/404");
            }

            // USER CHECK

            // Creates all the actions that the user can do - save or delete the entry, or don't save any changes
            $("#UserActionBar").append("<a href=\"javascript:void(0);\" id=\"SaveChanges\">Save</a><a href=\"/" + Topic() + "/admin\">Return</a>");
            // Inserts all topic data in input fields
            $("#TopicTitle").val(response[0].title);
            $("#TopicContent").val(response[0].content);
        }
    });
    // Adds a function to save button
    $("#SaveChanges").on("click", async function() {
        // Checks, if the fields have been filled
        if ($("#TopicTitle").val().trim().length > 0 && $("#SaveChanges").attr("value") != "disabled") {
            $("#SaveChanges").attr("value", "disabled");
            // Hides the error text
            $("#ErrorText").hide();
            $("#ErrorText").text("");
            // Prepares POST data
            let data = {
                title: $("#TopicTitle").val(),
                content: $("#TopicContent").val()
            };
            // Updates the topic and returns the results
            await $.ajax({
                url: "/topic/" + Topic(),
                method: "POST",
                data: data,
                success: function() {
                    // Topic page has been updated!
                    alert("Topic page has been updated!");
                },
                error: function(response) {
                    // Outputs an error message
                    $("#ErrorText").show();
                    $("#ErrorText").text(response.responseJSON.messages.error);
                }
            });
        }
        else {
            // Outputs an error message
            $("#ErrorText").show();
            $("#ErrorText").text("All input fields must be filled out!");
        }
    });
    $("#SaveChanges").attr("value", "");
    // Creates a list of allowed HTML tags
    const tagArray = ["a", "b", "br", "h2", "h3", "h4", "hr", "i", "ol", "ul", "li", "s", "span", "table", "td", "th", "tr", "u"];
    for (_ of tagArray) {
        $("#ListOfTags").append("<li>" + _ + "</li>");
    }
}