/*
    Created: 2025-02-27
    Author: Kārlis Grīnvalds
    Last edited: 2025-09-22
    Edited by: Kārlis Grīnvalds
*/

// Used for edit_entry.html

// Checks user's session data
async function UserBar(hasSession) {
    if (!hasSession) {
        // User is not allowed on this page without an open session
        Link("/error/403");
    }
}

// Shows the entry data in input fields and saves any changes
async function Load() {
    // Gets the url parameter
    const entryId = window.location.href.split("?entry=")[1];
    // Gets all the data from an entry
    await $.ajax({
        url: "/entry/" + entryId,
        method: "GET",
        success: async function(response) {
            // If no entry was found then user gets taken to error 404 page
            if (response.length <= 0) {
                Link("/error/404");
            }
            // Checks if the user can edit the entry
            await $.ajax({
                url: "/entry/permission/" + response[0].id,
                method: "GET",
                success: function(answer) {
                    if (!answer) {
                        // User wasn't allowed to edit the entry
                        Link("/error/403");
                    }
                }
            });
            // Creates all the actions that the user can do - save or delete the entry, or don't save any changes
            $("#UserActionBar").append("<a href=\"javascript:void(0);\" id=\"SaveChanges\">Save</a><a href=\"/" + Topic() + "/view?entry=" + entryId + "\">Cancel</a><a href=\"javascript:void(0);\" id=\"Delete\">Delete</a>");
            // Deletes the entry and returns the results
            $("#Delete").on("click", async function() {
                if ($("#SaveChanges").attr("value") != "disabled" && $("#Delete").attr("value") != "disabled") {
                    $("#Delete").attr("value", "disabled");
                    await $.ajax({
                        url: "/entry/" + entryId,
                        method: "DELETE",
                        success: function() {
                            // Entry has been deleted succesfully!
                            alert("Entry has been deleted!");
                            Link("/" + Topic() + "/main");
                        },
                        error: function() {
                            // Something went wrong in the deletion
                            $("#ErrorText").show();
                            $("#ErrorText").text("Data is missing!");
                        }
                    });
                }
            });
            // Inserts all entry data in input fields
            $("#EntryTitle").val(response[0].title);
            $("#EntryContent").val(response[0].content);
            // Adds a function to save button
            $("#SaveChanges").on("click", async function() {
                // Checks, if the fields have been filled
                if ($("#EntryTitle").val().trim().length > 0 && $("#SaveChanges").attr("value") != "disabled" && $("#Delete").attr("value") != "disabled") {
                    $("#SaveChanges").attr("value", "disabled");
                    // Hides the error text
                    $("#ErrorText").hide();
                    $("#ErrorText").text("");
                    // Prepares POST data
                    let data = {
                        title: $("#EntryTitle").val(),
                        content: $("#EntryContent").val()
                    };
                    // Updates the entry and returns the results
                    await $.ajax({
                        url: "/entry/" + entryId,
                        method: "POST",
                        data: data,
                        success: function() {
                            // Entry has been updated!
                            alert("Entry has been updated!");
                            // Returns user to the entry
                            Link("/" + Topic() + "/view?entry=" + entryId);
                        },
                        error: function(response) {
                            // Outputs an error message
                            $("#ErrorText").show();
                            $("#ErrorText").text(response.responseJSON.messages.error);
                        }
                    });
                }
                else {
                    // Outputs an error message
                    $("#ErrorText").show();
                    $("#ErrorText").text("All input fields must be filled out!");
                }
            });
            $("#SaveChanges").attr("value", "");
        }
    });
    // Creates a list of allowed HTML tags
    const tagArray = ["a", "b", "br", "h2", "h3", "h4", "hr", "i", "ol", "ul", "li", "s", "span", "table", "td", "th", "tr", "u"];
    for (_ of tagArray) {
        $("#ListOfTags").append("<li>" + _ + "</li>");
    }
}