/*
    Created: 2025-02-27
    Author: Kārlis Grīnvalds
    Last edited: 2025-09-22
    Edited by: Kārlis Grīnvalds
*/

// Used for create_entry.html

// Checks user's session data
async function UserBar(hasSession) {
    if (hasSession) {
        // User has an open session and can create a new entry
        $("#UserActionBar").append("<a href=\"javascript:void(0);\" id=\"SaveChanges\">Save</a><a href=\"/" + Topic() + "/admin\">Cancel</a>");
    }
    else {
        // User is not allowed on this page without an open session
        Link("/error/403");
    }
}

// Adds a function to save button that prepares all data to make a new entry
async function Load() {
    $("#SaveChanges").on("click", async function() {
        // Checks if the fields have been filled
        if ($("#EntryTitle").val().trim().length > 0 && $("#SaveChanges").attr("value") != "disabled") {
            $("#SaveChanges").attr("value", "disabled");
            // Hides the error text
            $("#ErrorText").hide();
            $("#ErrorText").text("");
            // Gets the user who wants to make this entry
            let user_id = 0;
            await $.ajax({
                url: "/user/session",
                method: "PUT",
                success: function(response) {
                    if ("id" in response && "username" in response) {
                        // User was found
                        user_id = response.id;
                    }
                    else {
                        // If the user doesn't have an open session then user gets taken to error 404 page and the entry doesn't get created
                        Link("/error/404");
                    }
                }
            });
            // Prepares POST data
            let data = {
                user: user_id,
                topic: Topic(),
                title: $("#EntryTitle").val(),
                content: $("#EntryContent").val(),
            };
            // Creates the entry and returns the results
            await $.ajax({
                url: "/entry/0",
                method: "POST",
                data: data,
                success: function() {
                    // Entry has been created!
                    alert("Entry has been created!");
                    // Returns user to main page
                    Link("/" + Topic() + "/admin");
                },
                error: function(response) {
                    // Outputs the error message
                    $("#ErrorText").show();
                    $("#ErrorText").text(response.responseJSON.messages.error);
                }
            }); 
        }
        else {
            // Outputs the error message
            $("#ErrorText").show();
            if ($("#SaveChanges").attr("value") == "disabled") {
                $("#ErrorText").text("Loading!");
            }
            else {
                $("#ErrorText").text("Entry needs a title!");
            }
        }
        $("#SaveChanges").attr("value", "");
    });
    // Creates a list of allowed HTML tags
    const tagArray = ["a", "b", "br", "h2", "h3", "h4", "hr", "i", "ol", "ul", "li", "s", "span", "table", "td", "th", "tr", "u"];
    for (_ of tagArray) {
        $("#ListOfTags").append("<li>" + _ + "</li>");
    }
}