/*
    Created: 2025-02-27
    Author: Kārlis Grīnvalds
    Last edited: 2025-09-17
    Edited by: Kārlis Grīnvalds
*/

// Checks user's session data
async function UserBar(hasSession) {
    if (hasSession) {
        // User is not allowed on this page with an open session
        Link("/error/403");
    }
}

// Adds functions to a button and input fields
async function Load() {
    // The enter button gets an "on submit" function
    $("#EnterBtn").on("click", function() {
        $("#EnterBtn").prop("disabled", true);
        SignUp();
    });
    // Input fields can run the same "on submit" function
    $("#UserNameInputField, #EmailInputField, #PasswordInputField, #VerifyPasswordInputField").on("keypress", function(e) {
        // Checks, if the key press was enter
        if(e.which == 13 || !$("#EnterBtn").prop("disabled")){
            $("#EnterBtn").prop("disabled", true);
            SignUp();
        }
    });
}

// Does the sign up process
async function SignUp() {
    // Checks, if all the requirements are met. If not, then an error gets shown
    if ($("#UserNameInputField").val().trim().length >= 4 && $("#UserNameInputField").val().trim().length <= 20 && $("#EmailInputField").val().trim().length > 0 && $("#PasswordInputField").val().trim().length >= 8) {
        if ($("#PasswordInputField").val().trim() == $("#VerifyPasswordInputField").val().trim()) {
            // Prepares the POST data
            let data = {
                username: $("#UserNameInputField").val(),
                email: $("#EmailInputField").val(),
                password: $("#PasswordInputField").val(),
            };
            // Hides the error text
            $("#ErrorText").hide();
            $("#ErrorText").text("");
            // Sends the data and recieves a response, if the account was made or not
            await $.ajax({
                url: "/user",
                method: "POST",
                data: data,
                success: function() {
                    alert("Account created! Please, log in!");
                    Link("/" + Topic() + "/log_in");
                },
                error: function(response) {
                    // Outputs an error message
                    $("#ErrorText").show();
                    $("#ErrorText").text(response.responseJSON.messages.error);
                    $("#EnterBtn").prop("disabled", false);
                }
            });
        }
        else {
            // Outputs an error message
            $("#ErrorText").show();
            $("#ErrorText").text("Passwords don't match!");
        }
    }
    else {
        // Outputs an error message
        $("#ErrorText").show();
        if ($("#UserNameInputField").val().trim().length == 0 || $("#EmailInputField").val().trim().length == 0 || $("#PasswordInputField").val().trim().length == 0) {
            $("#ErrorText").text("All input fields must be filled out!");
        }
        else if ($("#UserNameInputField").val().trim().length < 4) {
           $("#ErrorText").text("Username is too short!"); 
        }
        else if ($("#UserNameInputField").val().trim().length > 20) {
           $("#ErrorText").text("Username is too long!"); 
        }
        else if ($("#PasswordInputField").val().trim().length < 8) {
            $("#ErrorText").text("Password is too short!");
        }
        else {
            $("#ErrorText").text("Something wasn't done right!");
        }
    }
    $("#EnterBtn").prop("disabled", false);
}