<?php

namespace App\Controllers;
use Config\Database;
use CodeIgniter\RESTful\ResourceController;

class TransferController extends ResourceController
{
    /*
        Created: 2025-02-27
        Author: Kārlis Grīnvalds
        Last edited: 2025-09-16
        Edited by: Kārlis Grīnvalds
    */

    // Used for viewing certain HTML files on the website

    // Shows the index page
    public function Index() {
        return view("index.html");
    }

    // Shows the main page, parameters needs topic name
    public function MainPage($name = null) {
        $db = Database::connect();
        // Checks if the name is given
        if (empty($name)) {
            return view("errors/error404.html");
        }
        // Checks if topic exists
        $query = $db->query('CALL get_topic_by_name('.$db->escape($name).')');
        if (empty($query)) {
            return view("errors/error404.html");
        }
        return view("main_page.html");
    }

    // Shows the admin panel page, parameters needs topic name
    public function AdminPanel($name = null) {
        $db = Database::connect();
        // Checks if the name is given
        if (empty($name)) {
            return view("errors/error404.html");
        }
        // Checks if topic exists
        $query = $db->query('CALL get_topic_by_name('.$db->escape($name).')');
        if (empty($query)) {
            return view("errors/error404.html");
        }
        $session = service("session");
        $hasSession = false;
        if ($session->has("userdata")) {
            $hasSession = true;
        }
        $session->close();
        if ($hasSession) {
            return view("admin_panel.html");
        }
        return view("errors/error403.html");
    }

    // Shows a certain entry
    public function GoToEntry() {
        return view("view_entry.html");
    }

    // Entry creation form page
    public function CreateEntry() {
        // User must have an open session to view this page
        if ($this->CheckSession()) {
            return view("create_entry.html");
        }
        return view("errors/error403.html");
    }

    // Entry editing form page
    public function EditEntry() {
        // User must have an open session to view this page
        if ($this->CheckSession()) {
            return view("edit_entry.html");
        }
        return view("errors/error403.html");
    }

    // Topic editing form page
    public function EditTopic() {
        // User must have an open session to view this page
        if ($this->CheckSession()) {
            return view("edit_topic.html");
        }
        return view("errors/error403.html");
    }

    // Create account page
    public function ViewCreateAccountPage() {
        // User must not have an open session to view this page
        if ($this->CheckSession()) {
            return view("errors/error403.html");
        }
        return view("create_account.html");
    }

    // Log in page
    public function ViewLogInPage() {
        // User must not have an open session to view this page
        if ($this->CheckSession()) {
            return view("errors/error403.html");
        }
        return view("log_in.html");
    }

    // Search result page
    public function SearchPage() {
        return view("search.html");
    }

    // File upload page
    public function FileUploadPage() {
        // User must have an open session to view this page
        if ($this->CheckSession()) {
            return view("file_upload.html");
        }
        return view("errors/error403.html");
    }

    // Error page, parameters needs error number
    public function ErrorPage($number = null) {
        if (is_null($number)) {
            return view("errors/error404.html");
        }
        else {
            return view("errors/error".$number.".html");
        }
    }

    // Checks if user has an open session and returns a boolean
    function CheckSession() {
        $session = service("session");
        $hasSession = false;
        if ($session->has("userdata")) {
            $hasSession = true;
        }
        $session->close();
        return $hasSession;
    }
}