<?php

namespace App\Controllers;
use Config\Database;
use CodeIgniter\RESTful\ResourceController;

class TopicController extends ResourceController
{
    /*
        Created: 2025-09-16
        Author: Kārlis Grīnvalds
        Last edited: 2025-09-17
        Edited by: Kārlis Grīnvalds
    */

    // Retrieves a certain topic, function parameter is topic name
    public function GetTopic($name = null) {
        $db = Database::connect();
        if (empty($name)) {
            return $this->fail(["error" => "Where data?"], 400);
        }
        $query = $db->query('CALL get_topic_by_name('.$db->escape($name).')');
        if (empty($query)) {
            return $this->fail(["error" => "Not found!"], 404);
        }
        $responses = [];
        foreach ($query->getResult() as $row) {
            $responses[] = [
                "id" => $row->id,
                "title" => $row->title,
                "content" => $row->content,
                "created_at" => $row->created_at,
                "edited_at" => $row->edited_at,
            ];
        }
        return $this->respond($responses, 200);
    }

    // Updates topic, function parameter is topic name
    public function UpdateTopic($name = null) {
        $db = Database::connect();
        if (empty($name)) {
            return $this->fail(["error" => "Topic name not given!"], 400);
        }
        $item = [];
        $session = service("session");
        if ($session->has("userdata")) {
            $item = $session->get("userdata")->id;
            $session->close();
        }
        else {
            $session->close();
            return $this->fail(["error" => "User not found!"], 404);
        }
        // Checks if posted data exists
        if (empty($this->request->getPost())) {
            return $this->fail(["error" => "Input fields are empty!"], 400);
        }
        $query = $db->query('CALL get_topic_for_put('.$db->escape($name).')');
        if (empty($query)) {
            return $this->fail(["error" => "Topic not found!"], 404);
        }
        $query = $query->getResult()[0];
        if ($item != $query->owner) {
            return $this->fail(["error" => "You can't use this!"], 404);
        }
        // Prepares data for updating
        $sendData = [
            "title" => $this->CleanTitle($this->request->getPost("title")),
            "content" => $this->CleanContent($this->request->getPost("content"))
        ];
        // Checks if the title isn't empty
        if (strlen($sendData["title"]) == 0) {
            return $this->fail(["error" => "Title was found empty! Do not use any HTML tags!"], 406);
        }
        $db->query('CALL put_topic('.$db->escape(json_encode($sendData)).', '.$db->escape($query->id).')');
        return $this->respond(["message" => "Updated successfully!"], 200);
    }

    /* MISCELLANIOUS FUNCTIONS */

    // Removes restricted HTML tags from content, function parameter is text that needs to be cleaned
    public function CleanContent($string = null) {
        // Variables get created
        $allowedTags = array("a", "b", "br", "h2", "h3", "h4", "hr", "i", "ol", "ul", "li", "s", "span", "table", "td", "th", "tr", "u");
        $cleanedString = ""; // Returned string with allowed HTML tags
        $combination = ""; // Variable for string cleaning
        $foundSomething = false; // Variable for finding HTML tag
        // For loop cleans the string
        for ($_ = 0; $_ < strlen($string); $_++) {
            // Check if it can add the character to the cleaned string
            if ($foundSomething == false) {
                if ($string[$_] != "<") {
                    $cleanedString .= $string[$_];
                    continue;
                }
            }
            // If not, then it goes through the tag checking and cleaning process
            $foundSomething = true;
            $combination .= $string[$_];
            // If this runs, then these aren't tags and don't need to be worried about
            if ($combination == ">" || $combination == "< " || $combination == "<>") {
                $cleanedString .= $combination;
                $combination = "";
                $foundSomething = false;
            }
            // When reaching the end of the HTML tag, it will check, if it's allowed
            if ($string[$_] == ">" && $foundSomething == true) {
                $check = str_replace(">", "", str_replace("<", "", $combination));
                // Process for checking HTML link tag
                switch (explode(" ", $check)[0]) {
                    case "a":
                        $arrayCheck = explode(" ", $check);
                        // If the HTML link tag has only the "a" or is with href, then it's allowed
                        if (count($arrayCheck) == 1) {
                            $cleanedString .= $combination;
                        }
                        else {
                            if (count($arrayCheck) <= 2) {
                                if ($arrayCheck[1][0] == "h") {
                                    $cleanedString .= $combination;
                                }
                            }
                        }
                        break;
                    case "span":
                        $arrayCheck = explode(" ", $check);
                        // If the HTML link tag has only the "span" or is with style, then it's allowed
                        if (count($arrayCheck) == 1) {
                            $cleanedString .= $combination;
                        }
                        else {
                            if (count($arrayCheck) > 1) {
                                $styleText = "";
                                for ($index = 1; $index < count($arrayCheck); $index++) {
                                    $styleText .= $arrayCheck[$index];
                                }
                                $styleText = explode(":", $styleText);
                                if ($styleText[0] == "style=\"color" && count($styleText) == 2) {
                                    $cleanedString .= $combination;
                                }
                            }
                        }
                        break;
                    default:
                        // Process for checking any HTML tag
                        $check = str_replace("/", "", $check);
                        if (in_array($check, $allowedTags)) {
                            $cleanedString .= $combination;
                        }
                        break;
                }
                $combination = "";
                $foundSomething = false;
            }
        }
        // Returns the cleaned string from restricted HTML tags
        return $cleanedString;
    }

    // Removes all HTML tags from title, function parameter is text that needs to be removed from any tags
    public function CleanTitle($string = null) {
        // Variables get created
        $cleanedString = ""; // Returned string with allowed HTML tags
        $foundSomething = false; // Variable for finding HTML tag
        // For loop cleans the string
        for ($_ = 0; $_ < strlen($string); $_++) {
            // Check if it can add the character to the cleaned string
            if ($foundSomething == false) {
                if ($string[$_] != "<") {
                    $cleanedString .= $string[$_];
                    continue;
                }
            }
            $foundSomething = true;
            if ($string[$_] == ">") {
                $foundSomething = false;
            }
        }
        // Returns the cleaned string from all HTML tags
        return $cleanedString;
    }
}