/**
 * Copyright (C) 2018 Glayzzle (BSD3 License)
 * @authors https://github.com/glayzzle/php-parser/graphs/contributors
 * @url http://glayzzle.com
 */
"use strict";

const Declaration = require("./declaration");
const KIND = "function";

/**
 * Defines a classic function
 * @constructor Function
 * @memberOf module:php-parser
 * @extends {Declaration}
 * @property {Parameter[]} arguments
 * @property {Identifier} type
 * @property {boolean} byref
 * @property {boolean} nullable
 * @property {Block|null} body
 * @property {AttrGroup[]} attrGroups
 */
module.exports = Declaration.extends(
  KIND,
  function _Function(name, args, byref, type, nullable, docs, location) {
    Declaration.apply(this, [KIND, name, docs, location]);
    this.arguments = args;
    this.byref = byref;
    this.type = type;
    this.nullable = nullable;
    this.body = null;
    this.attrGroups = [];
  },
);
