export type LanguageName =
  | '1C Enterprise'
  | '2-Dimensional Array'
  | '4D'
  | 'ABAP'
  | 'ABAP CDS'
  | 'ABNF'
  | 'AGS Script'
  | 'AIDL'
  | 'AL'
  | 'AMPL'
  | 'ANTLR'
  | 'API Blueprint'
  | 'APL'
  | 'ASL'
  | 'ASN.1'
  | 'ASP.NET'
  | 'ATS'
  | 'ActionScript'
  | 'Ada'
  | 'Adblock Filter List'
  | 'Adobe Font Metrics'
  | 'Agda'
  | 'Aiken'
  | 'Alloy'
  | 'Alpine Abuild'
  | 'Altium Designer'
  | 'AngelScript'
  | 'Answer Set Programming'
  | 'Ant Build System'
  | 'Antlers'
  | 'ApacheConf'
  | 'Apex'
  | 'Apollo Guidance Computer'
  | 'AppleScript'
  | 'Arc'
  | 'AsciiDoc'
  | 'AspectJ'
  | 'Assembly'
  | 'Astro'
  | 'Asymptote'
  | 'Augeas'
  | 'AutoHotkey'
  | 'AutoIt'
  | 'Avro IDL'
  | 'Awk'
  | 'B4X'
  | 'BASIC'
  | 'BQN'
  | 'Ballerina'
  | 'Batchfile'
  | 'Beef'
  | 'Befunge'
  | 'Berry'
  | 'BibTeX'
  | 'BibTeX Style'
  | 'Bicep'
  | 'Bikeshed'
  | 'Bison'
  | 'BitBake'
  | 'Blade'
  | 'BlitzBasic'
  | 'BlitzMax'
  | 'Bluespec'
  | 'Bluespec BH'
  | 'Boo'
  | 'Boogie'
  | 'Brainfuck'
  | 'BrighterScript'
  | 'Brightscript'
  | 'Browserslist'
  | 'BuildStream'
  | 'C'
  | 'C#'
  | 'C++'
  | 'C-ObjDump'
  | 'C2hs Haskell'
  | 'C3'
  | 'CAP CDS'
  | 'CIL'
  | 'CLIPS'
  | 'CMake'
  | 'COBOL'
  | 'CODEOWNERS'
  | 'COLLADA'
  | 'CSON'
  | 'CSS'
  | 'CSV'
  | 'CUE'
  | 'CWeb'
  | 'Cabal Config'
  | 'Caddyfile'
  | 'Cadence'
  | 'Cairo'
  | 'Cairo Zero'
  | 'CameLIGO'
  | "Cap'n Proto"
  | 'Carbon'
  | 'CartoCSS'
  | 'Ceylon'
  | 'Chapel'
  | 'Charity'
  | 'Checksums'
  | 'ChucK'
  | 'Circom'
  | 'Cirru'
  | 'Clarion'
  | 'Clarity'
  | 'Classic ASP'
  | 'Clean'
  | 'Click'
  | 'Clojure'
  | 'Closure Templates'
  | 'Cloud Firestore Security Rules'
  | 'Clue'
  | 'CoNLL-U'
  | 'CodeQL'
  | 'CoffeeScript'
  | 'ColdFusion'
  | 'ColdFusion CFC'
  | 'Common Lisp'
  | 'Common Workflow Language'
  | 'Component Pascal'
  | 'Cooklang'
  | 'Cool'
  | 'Cpp-ObjDump'
  | 'Creole'
  | 'Crystal'
  | 'Csound'
  | 'Csound Document'
  | 'Csound Score'
  | 'Cuda'
  | 'Cue Sheet'
  | 'Curry'
  | 'Cycript'
  | 'Cylc'
  | 'Cypher'
  | 'Cython'
  | 'D'
  | 'D-ObjDump'
  | 'D2'
  | 'DIGITAL Command Language'
  | 'DM'
  | 'DNS Zone'
  | 'DTrace'
  | 'Dafny'
  | 'Darcs Patch'
  | 'Dart'
  | 'Daslang'
  | 'DataWeave'
  | 'Debian Package Control File'
  | 'DenizenScript'
  | 'Dhall'
  | 'Diff'
  | 'DirectX 3D File'
  | 'Dockerfile'
  | 'Dogescript'
  | 'Dotenv'
  | 'Dune'
  | 'Dylan'
  | 'E'
  | 'E-mail'
  | 'EBNF'
  | 'ECL'
  | 'ECLiPSe'
  | 'EJS'
  | 'EQ'
  | 'Eagle'
  | 'Earthly'
  | 'Easybuild'
  | 'Ecere Projects'
  | 'Ecmarkup'
  | 'Edge'
  | 'EdgeQL'
  | 'EditorConfig'
  | 'Edje Data Collection'
  | 'Eiffel'
  | 'Elixir'
  | 'Elm'
  | 'Elvish'
  | 'Elvish Transcript'
  | 'Emacs Lisp'
  | 'EmberScript'
  | 'Erlang'
  | 'Euphoria'
  | 'F#'
  | 'F*'
  | 'FIGlet Font'
  | 'FIRRTL'
  | 'FLUX'
  | 'Factor'
  | 'Fancy'
  | 'Fantom'
  | 'Faust'
  | 'Fennel'
  | 'Filebench WML'
  | 'Filterscript'
  | 'Fluent'
  | 'Formatted'
  | 'Forth'
  | 'Fortran'
  | 'Fortran Free Form'
  | 'FreeBASIC'
  | 'FreeMarker'
  | 'Frege'
  | 'Futhark'
  | 'G-code'
  | 'GAML'
  | 'GAMS'
  | 'GAP'
  | 'GCC Machine Description'
  | 'GDB'
  | 'GDScript'
  | 'GDShader'
  | 'GEDCOM'
  | 'GLSL'
  | 'GN'
  | 'GSC'
  | 'Game Maker Language'
  | 'Gemfile.lock'
  | 'Gemini'
  | 'Genero 4gl'
  | 'Genero per'
  | 'Genie'
  | 'Genshi'
  | 'Gentoo Ebuild'
  | 'Gentoo Eclass'
  | 'Gerber Image'
  | 'Gettext Catalog'
  | 'Gherkin'
  | 'Git Attributes'
  | 'Git Config'
  | 'Git Revision List'
  | 'Gleam'
  | 'Glimmer JS'
  | 'Glimmer TS'
  | 'Glyph'
  | 'Glyph Bitmap Distribution Format'
  | 'Gnuplot'
  | 'Go'
  | 'Go Checksums'
  | 'Go Module'
  | 'Go Workspace'
  | 'Godot Resource'
  | 'Golo'
  | 'Gosu'
  | 'Grace'
  | 'Gradle'
  | 'Gradle Kotlin DSL'
  | 'Grammatical Framework'
  | 'Graph Modeling Language'
  | 'GraphQL'
  | 'Graphviz (DOT)'
  | 'Groovy'
  | 'Groovy Server Pages'
  | 'HAProxy'
  | 'HCL'
  | 'HIP'
  | 'HLSL'
  | 'HOCON'
  | 'HTML'
  | 'HTML+ECR'
  | 'HTML+EEX'
  | 'HTML+ERB'
  | 'HTML+PHP'
  | 'HTML+Razor'
  | 'HTTP'
  | 'HXML'
  | 'Hack'
  | 'Haml'
  | 'Handlebars'
  | 'Harbour'
  | 'Hare'
  | 'Haskell'
  | 'Haxe'
  | 'HiveQL'
  | 'HolyC'
  | 'Hosts File'
  | 'Hy'
  | 'HyPhy'
  | 'IDL'
  | 'IGOR Pro'
  | 'INI'
  | 'IRC log'
  | 'ISPC'
  | 'Idris'
  | 'Ignore List'
  | 'ImageJ Macro'
  | 'Imba'
  | 'Inform 7'
  | 'Ink'
  | 'Inno Setup'
  | 'Io'
  | 'Ioke'
  | 'Isabelle'
  | 'Isabelle ROOT'
  | 'J'
  | 'JAR Manifest'
  | 'JCL'
  | 'JFlex'
  | 'JSON'
  | 'JSON with Comments'
  | 'JSON5'
  | 'JSONLD'
  | 'JSONiq'
  | 'Jai'
  | 'Janet'
  | 'Jasmin'
  | 'Java'
  | 'Java Properties'
  | 'Java Server Pages'
  | 'Java Template Engine'
  | 'JavaScript'
  | 'JavaScript+ERB'
  | 'Jest Snapshot'
  | 'JetBrains MPS'
  | 'Jinja'
  | 'Jison'
  | 'Jison Lex'
  | 'Jolie'
  | 'Jsonnet'
  | 'Julia'
  | 'Julia REPL'
  | 'Jupyter Notebook'
  | 'Just'
  | 'KDL'
  | 'KRL'
  | 'Kaitai Struct'
  | 'KakouneScript'
  | 'KerboScript'
  | 'KiCad Layout'
  | 'KiCad Legacy Layout'
  | 'KiCad Schematic'
  | 'Kickstart'
  | 'Kit'
  | 'Koka'
  | 'Kotlin'
  | 'Kusto'
  | 'LFE'
  | 'LLVM'
  | 'LOLCODE'
  | 'LSL'
  | 'LTspice Symbol'
  | 'LabVIEW'
  | 'Lark'
  | 'Lasso'
  | 'Latte'
  | 'Lean'
  | 'Lean 4'
  | 'Leo'
  | 'Less'
  | 'Lex'
  | 'LigoLANG'
  | 'LilyPond'
  | 'Limbo'
  | 'Linear Programming'
  | 'Linker Script'
  | 'Linux Kernel Module'
  | 'Liquid'
  | 'Literate Agda'
  | 'Literate CoffeeScript'
  | 'Literate Haskell'
  | 'LiveCode Script'
  | 'LiveScript'
  | 'Logos'
  | 'Logtalk'
  | 'LookML'
  | 'LoomScript'
  | 'Lua'
  | 'Luau'
  | 'M'
  | 'M3U'
  | 'M4'
  | 'M4Sugar'
  | 'MATLAB'
  | 'MAXScript'
  | 'MDX'
  | 'MLIR'
  | 'MQL4'
  | 'MQL5'
  | 'MTML'
  | 'MUF'
  | 'Macaulay2'
  | 'Makefile'
  | 'Mako'
  | 'Markdown'
  | 'Marko'
  | 'Mask'
  | 'Mathematica'
  | 'Maven POM'
  | 'Max'
  | 'Mercury'
  | 'Mermaid'
  | 'Meson'
  | 'Metal'
  | 'Microsoft Developer Studio Project'
  | 'Microsoft Visual Studio Solution'
  | 'MiniD'
  | 'MiniYAML'
  | 'MiniZinc'
  | 'MiniZinc Data'
  | 'Mint'
  | 'Mirah'
  | 'Modelica'
  | 'Modula-2'
  | 'Modula-3'
  | 'Module Management System'
  | 'Mojo'
  | 'Monkey'
  | 'Monkey C'
  | 'Moocode'
  | 'MoonBit'
  | 'MoonScript'
  | 'Motoko'
  | 'Motorola 68K Assembly'
  | 'Move'
  | 'Muse'
  | 'Mustache'
  | 'Myghty'
  | 'NASL'
  | 'NCL'
  | 'NEON'
  | 'NL'
  | 'NMODL'
  | 'NPM Config'
  | 'NSIS'
  | 'NWScript'
  | 'Nasal'
  | 'Nearley'
  | 'Nemerle'
  | 'NetLinx'
  | 'NetLinx+ERB'
  | 'NetLogo'
  | 'NewLisp'
  | 'Nextflow'
  | 'Nginx'
  | 'Nickel'
  | 'Nim'
  | 'Ninja'
  | 'Nit'
  | 'Nix'
  | 'Noir'
  | 'Nu'
  | 'NumPy'
  | 'Nunjucks'
  | 'Nushell'
  | 'OASv2-json'
  | 'OASv2-yaml'
  | 'OASv3-json'
  | 'OASv3-yaml'
  | 'OCaml'
  | 'OMNeT++ MSG'
  | 'OMNeT++ NED'
  | 'Oberon'
  | 'ObjDump'
  | 'Object Data Instance Notation'
  | 'ObjectScript'
  | 'Objective-C'
  | 'Objective-C++'
  | 'Objective-J'
  | 'Odin'
  | 'Omgrofl'
  | 'Opa'
  | 'Opal'
  | 'Open Policy Agent'
  | 'OpenAPI Specification v2'
  | 'OpenAPI Specification v3'
  | 'OpenCL'
  | 'OpenEdge ABL'
  | 'OpenQASM'
  | 'OpenRC runscript'
  | 'OpenSCAD'
  | 'OpenStep Property List'
  | 'OpenType Feature File'
  | 'Option List'
  | 'Org'
  | 'OverpassQL'
  | 'Ox'
  | 'Oxygene'
  | 'Oz'
  | 'P4'
  | 'PDDL'
  | 'PEG.js'
  | 'PHP'
  | 'PLSQL'
  | 'PLpgSQL'
  | 'POV-Ray SDL'
  | 'Pact'
  | 'Pan'
  | 'Papyrus'
  | 'Parrot'
  | 'Parrot Assembly'
  | 'Parrot Internal Representation'
  | 'Pascal'
  | 'Pawn'
  | 'Pep8'
  | 'Perl'
  | 'Pic'
  | 'Pickle'
  | 'PicoLisp'
  | 'PigLatin'
  | 'Pike'
  | 'Pip Requirements'
  | 'Pkl'
  | 'PlantUML'
  | 'Pod'
  | 'Pod 6'
  | 'PogoScript'
  | 'Polar'
  | 'Pony'
  | 'Portugol'
  | 'PostCSS'
  | 'PostScript'
  | 'PowerBuilder'
  | 'PowerShell'
  | 'Praat'
  | 'Prisma'
  | 'Processing'
  | 'Procfile'
  | 'Proguard'
  | 'Prolog'
  | 'Promela'
  | 'Propeller Spin'
  | 'Protocol Buffer'
  | 'Protocol Buffer Text Format'
  | 'Public Key'
  | 'Pug'
  | 'Puppet'
  | 'Pure Data'
  | 'PureBasic'
  | 'PureScript'
  | 'Pyret'
  | 'Python'
  | 'Python console'
  | 'Python traceback'
  | 'Q#'
  | 'QML'
  | 'QMake'
  | 'Qt Script'
  | 'Quake'
  | 'QuakeC'
  | 'QuickBASIC'
  | 'R'
  | 'RAML'
  | 'RBS'
  | 'RDoc'
  | 'REALbasic'
  | 'REXX'
  | 'RMarkdown'
  | 'RON'
  | 'ROS Interface'
  | 'RPC'
  | 'RPGLE'
  | 'RPM Spec'
  | 'RUNOFF'
  | 'Racket'
  | 'Ragel'
  | 'Raku'
  | 'Rascal'
  | 'Raw token data'
  | 'ReScript'
  | 'Readline Config'
  | 'Reason'
  | 'ReasonLIGO'
  | 'Rebol'
  | 'Record Jar'
  | 'Red'
  | 'Redcode'
  | 'Redirect Rules'
  | 'Regular Expression'
  | "Ren'Py"
  | 'RenderScript'
  | 'Rez'
  | 'Rich Text Format'
  | 'Ring'
  | 'Riot'
  | 'RobotFramework'
  | 'Roc'
  | 'Rocq Prover'
  | 'Roff'
  | 'Roff Manpage'
  | 'Rouge'
  | 'RouterOS Script'
  | 'Ruby'
  | 'Rust'
  | 'SAS'
  | 'SCSS'
  | 'SELinux Policy'
  | 'SMT'
  | 'SPARQL'
  | 'SQF'
  | 'SQL'
  | 'SQLPL'
  | 'SRecode Template'
  | 'SSH Config'
  | 'STAR'
  | 'STL'
  | 'STON'
  | 'SVG'
  | 'SWIG'
  | 'Sage'
  | 'Sail'
  | 'SaltStack'
  | 'Sass'
  | 'Scala'
  | 'Scaml'
  | 'Scenic'
  | 'Scheme'
  | 'Scilab'
  | 'Self'
  | 'ShaderLab'
  | 'Shell'
  | 'ShellCheck Config'
  | 'ShellSession'
  | 'Shen'
  | 'Sieve'
  | 'Simple File Verification'
  | 'Singularity'
  | 'Slang'
  | 'Slash'
  | 'Slice'
  | 'Slim'
  | 'Slint'
  | 'SmPL'
  | 'Smali'
  | 'Smalltalk'
  | 'Smarty'
  | 'Smithy'
  | 'Snakemake'
  | 'Solidity'
  | 'Soong'
  | 'SourcePawn'
  | 'Spline Font Database'
  | 'Squirrel'
  | 'Stan'
  | 'Standard ML'
  | 'Starlark'
  | 'Stata'
  | 'StringTemplate'
  | 'Stylus'
  | 'SubRip Text'
  | 'SugarSS'
  | 'SuperCollider'
  | 'Survex data'
  | 'Svelte'
  | 'Sway'
  | 'Sweave'
  | 'Swift'
  | 'SystemVerilog'
  | 'TI Program'
  | 'TL-Verilog'
  | 'TLA'
  | 'TOML'
  | 'TSPLIB data'
  | 'TSQL'
  | 'TSV'
  | 'TSX'
  | 'TXL'
  | 'Tact'
  | 'Talon'
  | 'Tcl'
  | 'Tcsh'
  | 'TeX'
  | 'Tea'
  | 'Terra'
  | 'Terraform Template'
  | 'Texinfo'
  | 'Text'
  | 'TextGrid'
  | 'TextMate Properties'
  | 'Textile'
  | 'Thrift'
  | 'Toit'
  | 'Tor Config'
  | 'Tree-sitter Query'
  | 'Turing'
  | 'Turtle'
  | 'Twig'
  | 'Type Language'
  | 'TypeScript'
  | 'TypeSpec'
  | 'Typst'
  | 'Unified Parallel C'
  | 'Unity3D Asset'
  | 'Unix Assembly'
  | 'Uno'
  | 'UnrealScript'
  | 'Untyped Plutus Core'
  | 'UrWeb'
  | 'V'
  | 'VBA'
  | 'VBScript'
  | 'VCL'
  | 'VHDL'
  | 'Vala'
  | 'Valve Data Format'
  | 'Velocity Template Language'
  | 'Vento'
  | 'Verilog'
  | 'Vim Help File'
  | 'Vim Script'
  | 'Vim Snippet'
  | 'Visual Basic .NET'
  | 'Visual Basic 6.0'
  | 'Volt'
  | 'Vue'
  | 'Vyper'
  | 'WDL'
  | 'WGSL'
  | 'Wavefront Material'
  | 'Wavefront Object'
  | 'Web Ontology Language'
  | 'WebAssembly'
  | 'WebAssembly Interface Type'
  | 'WebIDL'
  | 'WebVTT'
  | 'Wget Config'
  | 'Whiley'
  | 'Wikitext'
  | 'Win32 Message File'
  | 'Windows Registry Entries'
  | 'Witcher Script'
  | 'Wollok'
  | 'World of Warcraft Addon Data'
  | 'Wren'
  | 'X BitMap'
  | 'X Font Directory Index'
  | 'X PixMap'
  | 'X10'
  | 'XC'
  | 'XCompose'
  | 'XML'
  | 'XML Property List'
  | 'XPages'
  | 'XProc'
  | 'XQuery'
  | 'XS'
  | 'XSLT'
  | 'Xmake'
  | 'Xojo'
  | 'Xonsh'
  | 'Xtend'
  | 'YAML'
  | 'YANG'
  | 'YARA'
  | 'YASnippet'
  | 'Yacc'
  | 'Yul'
  | 'ZAP'
  | 'ZIL'
  | 'Zeek'
  | 'ZenScript'
  | 'Zephir'
  | 'Zig'
  | 'Zimpl'
  | 'Zmodel'
  | 'cURL Config'
  | 'crontab'
  | 'desktop'
  | 'dircolors'
  | 'eC'
  | 'edn'
  | 'fish'
  | 'hoon'
  | 'iCalendar'
  | 'jq'
  | 'kvlang'
  | 'mIRC Script'
  | 'mcfunction'
  | 'mdsvex'
  | 'mupad'
  | 'nanorc'
  | 'nesC'
  | 'ooc'
  | 'q'
  | 'reStructuredText'
  | 'robots.txt'
  | 'sed'
  | 'templ'
  | 'vCard'
  | 'wisp'
  | 'xBase'

export interface Language {
  /**
   * Language name.
   */
  readonly name: string
  /**
   * Either "data", "programming", "markup" or "prose".
   */
  readonly type: string
  /**
   * Ace mode used when editing files which use the language. This must match
   * one of the names in https://gh.io/acemodes. Use "text" if no mode exists.
   */
  readonly aceMode: string
  /**
   * List of associated file extensions, sorted in ascending ASCII order,
   * except for the language's primary extension, which is always listed first.
   */
  readonly extensions?: readonly string[]
  /**
   * List of associated filenames, sorted in ascending ASCII order.
   * May be omitted if the extensions field is present (and vice versa).
   */
  readonly filenames?: readonly string[]
  /**
   * Unique identifier used internally by GitHub, generated by running
   * `script/update-ids`. Do not fill out this field manually.
   */
  readonly languageId: number
  /**
   * The TextMate scope that represents this programming language.
   * This should match one of the scopes listed in grammars.yml.
   * Use "none" if there is no TextMate grammar for this language.
   */
  readonly tmScope: string
  /**
   * List of additional aliases (implicitly includes lowercased forms of language's name).
   * These are used in fenced code-blocks, code searches by language, and in overrides.
   */
  readonly aliases?: readonly string[]
  /**
   * CodeMirror 5 mode used when editing files that use the language.
   * This must match one of the names listed here: https://git.io/vi9Fx
   */
  readonly codemirrorMode?: string
  /**
   * MIME media-type used by CodeMirror 5 for selecting a mode for editing the language.
   * The `mime` types supported by the named mode are listed here: https://git.io/f4SoQ
   */
  readonly codemirrorMimeType?: string
  /**
   * CSS colour code used to represent the language (format: "#RRGGBB").
   */
  readonly color?: string
  /**
   * Name of the parent language. Languages in a group contribute to the usage statistics
   * of their parent language.
   */
  readonly group?: string
  /**
   * List of programs that execute the language (by running and/or compiling it).
   * These are consulted when scrutinising a file's hashbang to determine its language.
   */
  readonly interpreters?: readonly string[]
  /**
   * Enable soft line-wrapping (default: false)
   */
  readonly wrap?: boolean
}

export { default as '1C Enterprise' } from '../data/1C_20_Enterprise.mjs'
export { default as '2-Dimensional Array' } from '../data/2-Dimensional_20_Array.mjs'
export { default as '4D' } from '../data/4D.mjs'
export { default as 'ABAP' } from '../data/ABAP.mjs'
export { default as 'ABAP CDS' } from '../data/ABAP_20_CDS.mjs'
export { default as 'ABNF' } from '../data/ABNF.mjs'
export { default as 'AGS Script' } from '../data/AGS_20_Script.mjs'
export { default as 'AIDL' } from '../data/AIDL.mjs'
export { default as 'AL' } from '../data/AL.mjs'
export { default as 'AMPL' } from '../data/AMPL.mjs'
export { default as 'ANTLR' } from '../data/ANTLR.mjs'
export { default as 'API Blueprint' } from '../data/API_20_Blueprint.mjs'
export { default as 'APL' } from '../data/APL.mjs'
export { default as 'ASL' } from '../data/ASL.mjs'
export { default as 'ASN.1' } from '../data/ASN.1.mjs'
export { default as 'ASP.NET' } from '../data/ASP.NET.mjs'
export { default as 'ATS' } from '../data/ATS.mjs'
export { default as 'ActionScript' } from '../data/ActionScript.mjs'
export { default as 'Ada' } from '../data/Ada.mjs'
export { default as 'Adblock Filter List' } from '../data/Adblock_20_Filter_20_List.mjs'
export { default as 'Adobe Font Metrics' } from '../data/Adobe_20_Font_20_Metrics.mjs'
export { default as 'Agda' } from '../data/Agda.mjs'
export { default as 'Aiken' } from '../data/Aiken.mjs'
export { default as 'Alloy' } from '../data/Alloy.mjs'
export { default as 'Alpine Abuild' } from '../data/Alpine_20_Abuild.mjs'
export { default as 'Altium Designer' } from '../data/Altium_20_Designer.mjs'
export { default as 'AngelScript' } from '../data/AngelScript.mjs'
export { default as 'Answer Set Programming' } from '../data/Answer_20_Set_20_Programming.mjs'
export { default as 'Ant Build System' } from '../data/Ant_20_Build_20_System.mjs'
export { default as 'Antlers' } from '../data/Antlers.mjs'
export { default as 'ApacheConf' } from '../data/ApacheConf.mjs'
export { default as 'Apex' } from '../data/Apex.mjs'
export { default as 'Apollo Guidance Computer' } from '../data/Apollo_20_Guidance_20_Computer.mjs'
export { default as 'AppleScript' } from '../data/AppleScript.mjs'
export { default as 'Arc' } from '../data/Arc.mjs'
export { default as 'AsciiDoc' } from '../data/AsciiDoc.mjs'
export { default as 'AspectJ' } from '../data/AspectJ.mjs'
export { default as 'Assembly' } from '../data/Assembly.mjs'
export { default as 'Astro' } from '../data/Astro.mjs'
export { default as 'Asymptote' } from '../data/Asymptote.mjs'
export { default as 'Augeas' } from '../data/Augeas.mjs'
export { default as 'AutoHotkey' } from '../data/AutoHotkey.mjs'
export { default as 'AutoIt' } from '../data/AutoIt.mjs'
export { default as 'Avro IDL' } from '../data/Avro_20_IDL.mjs'
export { default as 'Awk' } from '../data/Awk.mjs'
export { default as 'B4X' } from '../data/B4X.mjs'
export { default as 'BASIC' } from '../data/BASIC.mjs'
export { default as 'BQN' } from '../data/BQN.mjs'
export { default as 'Ballerina' } from '../data/Ballerina.mjs'
export { default as 'Batchfile' } from '../data/Batchfile.mjs'
export { default as 'Beef' } from '../data/Beef.mjs'
export { default as 'Befunge' } from '../data/Befunge.mjs'
export { default as 'Berry' } from '../data/Berry.mjs'
export { default as 'BibTeX' } from '../data/BibTeX.mjs'
export { default as 'BibTeX Style' } from '../data/BibTeX_20_Style.mjs'
export { default as 'Bicep' } from '../data/Bicep.mjs'
export { default as 'Bikeshed' } from '../data/Bikeshed.mjs'
export { default as 'Bison' } from '../data/Bison.mjs'
export { default as 'BitBake' } from '../data/BitBake.mjs'
export { default as 'Blade' } from '../data/Blade.mjs'
export { default as 'BlitzBasic' } from '../data/BlitzBasic.mjs'
export { default as 'BlitzMax' } from '../data/BlitzMax.mjs'
export { default as 'Bluespec' } from '../data/Bluespec.mjs'
export { default as 'Bluespec BH' } from '../data/Bluespec_20_BH.mjs'
export { default as 'Boo' } from '../data/Boo.mjs'
export { default as 'Boogie' } from '../data/Boogie.mjs'
export { default as 'Brainfuck' } from '../data/Brainfuck.mjs'
export { default as 'BrighterScript' } from '../data/BrighterScript.mjs'
export { default as 'Brightscript' } from '../data/Brightscript.mjs'
export { default as 'Browserslist' } from '../data/Browserslist.mjs'
export { default as 'BuildStream' } from '../data/BuildStream.mjs'
export { default as 'C' } from '../data/C.mjs'
export { default as 'C#' } from '../data/C_23_.mjs'
export { default as 'C++' } from '../data/C_2b__2b_.mjs'
export { default as 'C-ObjDump' } from '../data/C-ObjDump.mjs'
export { default as 'C2hs Haskell' } from '../data/C2hs_20_Haskell.mjs'
export { default as 'C3' } from '../data/C3.mjs'
export { default as 'CAP CDS' } from '../data/CAP_20_CDS.mjs'
export { default as 'CIL' } from '../data/CIL.mjs'
export { default as 'CLIPS' } from '../data/CLIPS.mjs'
export { default as 'CMake' } from '../data/CMake.mjs'
export { default as 'COBOL' } from '../data/COBOL.mjs'
export { default as 'CODEOWNERS' } from '../data/CODEOWNERS.mjs'
export { default as 'COLLADA' } from '../data/COLLADA.mjs'
export { default as 'CSON' } from '../data/CSON.mjs'
export { default as 'CSS' } from '../data/CSS.mjs'
export { default as 'CSV' } from '../data/CSV.mjs'
export { default as 'CUE' } from '../data/CUE.mjs'
export { default as 'CWeb' } from '../data/CWeb.mjs'
export { default as 'Cabal Config' } from '../data/Cabal_20_Config.mjs'
export { default as 'Caddyfile' } from '../data/Caddyfile.mjs'
export { default as 'Cadence' } from '../data/Cadence.mjs'
export { default as 'Cairo' } from '../data/Cairo.mjs'
export { default as 'Cairo Zero' } from '../data/Cairo_20_Zero.mjs'
export { default as 'CameLIGO' } from '../data/CameLIGO.mjs'
export { default as "Cap'n Proto" } from '../data/Cap_27_n_20_Proto.mjs'
export { default as 'Carbon' } from '../data/Carbon.mjs'
export { default as 'CartoCSS' } from '../data/CartoCSS.mjs'
export { default as 'Ceylon' } from '../data/Ceylon.mjs'
export { default as 'Chapel' } from '../data/Chapel.mjs'
export { default as 'Charity' } from '../data/Charity.mjs'
export { default as 'Checksums' } from '../data/Checksums.mjs'
export { default as 'ChucK' } from '../data/ChucK.mjs'
export { default as 'Circom' } from '../data/Circom.mjs'
export { default as 'Cirru' } from '../data/Cirru.mjs'
export { default as 'Clarion' } from '../data/Clarion.mjs'
export { default as 'Clarity' } from '../data/Clarity.mjs'
export { default as 'Classic ASP' } from '../data/Classic_20_ASP.mjs'
export { default as 'Clean' } from '../data/Clean.mjs'
export { default as 'Click' } from '../data/Click.mjs'
export { default as 'Clojure' } from '../data/Clojure.mjs'
export { default as 'Closure Templates' } from '../data/Closure_20_Templates.mjs'
export { default as 'Cloud Firestore Security Rules' } from '../data/Cloud_20_Firestore_20_Security_20_Rules.mjs'
export { default as 'Clue' } from '../data/Clue.mjs'
export { default as 'CoNLL-U' } from '../data/CoNLL-U.mjs'
export { default as 'CodeQL' } from '../data/CodeQL.mjs'
export { default as 'CoffeeScript' } from '../data/CoffeeScript.mjs'
export { default as 'ColdFusion' } from '../data/ColdFusion.mjs'
export { default as 'ColdFusion CFC' } from '../data/ColdFusion_20_CFC.mjs'
export { default as 'Common Lisp' } from '../data/Common_20_Lisp.mjs'
export { default as 'Common Workflow Language' } from '../data/Common_20_Workflow_20_Language.mjs'
export { default as 'Component Pascal' } from '../data/Component_20_Pascal.mjs'
export { default as 'Cooklang' } from '../data/Cooklang.mjs'
export { default as 'Cool' } from '../data/Cool.mjs'
export { default as 'Cpp-ObjDump' } from '../data/Cpp-ObjDump.mjs'
export { default as 'Creole' } from '../data/Creole.mjs'
export { default as 'Crystal' } from '../data/Crystal.mjs'
export { default as 'Csound' } from '../data/Csound.mjs'
export { default as 'Csound Document' } from '../data/Csound_20_Document.mjs'
export { default as 'Csound Score' } from '../data/Csound_20_Score.mjs'
export { default as 'Cuda' } from '../data/Cuda.mjs'
export { default as 'Cue Sheet' } from '../data/Cue_20_Sheet.mjs'
export { default as 'Curry' } from '../data/Curry.mjs'
export { default as 'Cycript' } from '../data/Cycript.mjs'
export { default as 'Cylc' } from '../data/Cylc.mjs'
export { default as 'Cypher' } from '../data/Cypher.mjs'
export { default as 'Cython' } from '../data/Cython.mjs'
export { default as 'D' } from '../data/D.mjs'
export { default as 'D-ObjDump' } from '../data/D-ObjDump.mjs'
export { default as 'D2' } from '../data/D2.mjs'
export { default as 'DIGITAL Command Language' } from '../data/DIGITAL_20_Command_20_Language.mjs'
export { default as 'DM' } from '../data/DM.mjs'
export { default as 'DNS Zone' } from '../data/DNS_20_Zone.mjs'
export { default as 'DTrace' } from '../data/DTrace.mjs'
export { default as 'Dafny' } from '../data/Dafny.mjs'
export { default as 'Darcs Patch' } from '../data/Darcs_20_Patch.mjs'
export { default as 'Dart' } from '../data/Dart.mjs'
export { default as 'Daslang' } from '../data/Daslang.mjs'
export { default as 'DataWeave' } from '../data/DataWeave.mjs'
export { default as 'Debian Package Control File' } from '../data/Debian_20_Package_20_Control_20_File.mjs'
export { default as 'DenizenScript' } from '../data/DenizenScript.mjs'
export { default as 'Dhall' } from '../data/Dhall.mjs'
export { default as 'Diff' } from '../data/Diff.mjs'
export { default as 'DirectX 3D File' } from '../data/DirectX_20_3D_20_File.mjs'
export { default as 'Dockerfile' } from '../data/Dockerfile.mjs'
export { default as 'Dogescript' } from '../data/Dogescript.mjs'
export { default as 'Dotenv' } from '../data/Dotenv.mjs'
export { default as 'Dune' } from '../data/Dune.mjs'
export { default as 'Dylan' } from '../data/Dylan.mjs'
export { default as 'E' } from '../data/E.mjs'
export { default as 'E-mail' } from '../data/E-mail.mjs'
export { default as 'EBNF' } from '../data/EBNF.mjs'
export { default as 'ECL' } from '../data/ECL.mjs'
export { default as 'ECLiPSe' } from '../data/ECLiPSe.mjs'
export { default as 'EJS' } from '../data/EJS.mjs'
export { default as 'EQ' } from '../data/EQ.mjs'
export { default as 'Eagle' } from '../data/Eagle.mjs'
export { default as 'Earthly' } from '../data/Earthly.mjs'
export { default as 'Easybuild' } from '../data/Easybuild.mjs'
export { default as 'Ecere Projects' } from '../data/Ecere_20_Projects.mjs'
export { default as 'Ecmarkup' } from '../data/Ecmarkup.mjs'
export { default as 'Edge' } from '../data/Edge.mjs'
export { default as 'EdgeQL' } from '../data/EdgeQL.mjs'
export { default as 'EditorConfig' } from '../data/EditorConfig.mjs'
export { default as 'Edje Data Collection' } from '../data/Edje_20_Data_20_Collection.mjs'
export { default as 'Eiffel' } from '../data/Eiffel.mjs'
export { default as 'Elixir' } from '../data/Elixir.mjs'
export { default as 'Elm' } from '../data/Elm.mjs'
export { default as 'Elvish' } from '../data/Elvish.mjs'
export { default as 'Elvish Transcript' } from '../data/Elvish_20_Transcript.mjs'
export { default as 'Emacs Lisp' } from '../data/Emacs_20_Lisp.mjs'
export { default as 'EmberScript' } from '../data/EmberScript.mjs'
export { default as 'Erlang' } from '../data/Erlang.mjs'
export { default as 'Euphoria' } from '../data/Euphoria.mjs'
export { default as 'F#' } from '../data/F_23_.mjs'
export { default as 'F*' } from '../data/F_2a_.mjs'
export { default as 'FIGlet Font' } from '../data/FIGlet_20_Font.mjs'
export { default as 'FIRRTL' } from '../data/FIRRTL.mjs'
export { default as 'FLUX' } from '../data/FLUX.mjs'
export { default as 'Factor' } from '../data/Factor.mjs'
export { default as 'Fancy' } from '../data/Fancy.mjs'
export { default as 'Fantom' } from '../data/Fantom.mjs'
export { default as 'Faust' } from '../data/Faust.mjs'
export { default as 'Fennel' } from '../data/Fennel.mjs'
export { default as 'Filebench WML' } from '../data/Filebench_20_WML.mjs'
export { default as 'Filterscript' } from '../data/Filterscript.mjs'
export { default as 'Fluent' } from '../data/Fluent.mjs'
export { default as 'Formatted' } from '../data/Formatted.mjs'
export { default as 'Forth' } from '../data/Forth.mjs'
export { default as 'Fortran' } from '../data/Fortran.mjs'
export { default as 'Fortran Free Form' } from '../data/Fortran_20_Free_20_Form.mjs'
export { default as 'FreeBASIC' } from '../data/FreeBASIC.mjs'
export { default as 'FreeMarker' } from '../data/FreeMarker.mjs'
export { default as 'Frege' } from '../data/Frege.mjs'
export { default as 'Futhark' } from '../data/Futhark.mjs'
export { default as 'G-code' } from '../data/G-code.mjs'
export { default as 'GAML' } from '../data/GAML.mjs'
export { default as 'GAMS' } from '../data/GAMS.mjs'
export { default as 'GAP' } from '../data/GAP.mjs'
export { default as 'GCC Machine Description' } from '../data/GCC_20_Machine_20_Description.mjs'
export { default as 'GDB' } from '../data/GDB.mjs'
export { default as 'GDScript' } from '../data/GDScript.mjs'
export { default as 'GDShader' } from '../data/GDShader.mjs'
export { default as 'GEDCOM' } from '../data/GEDCOM.mjs'
export { default as 'GLSL' } from '../data/GLSL.mjs'
export { default as 'GN' } from '../data/GN.mjs'
export { default as 'GSC' } from '../data/GSC.mjs'
export { default as 'Game Maker Language' } from '../data/Game_20_Maker_20_Language.mjs'
export { default as 'Gemfile.lock' } from '../data/Gemfile.lock.mjs'
export { default as 'Gemini' } from '../data/Gemini.mjs'
export { default as 'Genero 4gl' } from '../data/Genero_20_4gl.mjs'
export { default as 'Genero per' } from '../data/Genero_20_per.mjs'
export { default as 'Genie' } from '../data/Genie.mjs'
export { default as 'Genshi' } from '../data/Genshi.mjs'
export { default as 'Gentoo Ebuild' } from '../data/Gentoo_20_Ebuild.mjs'
export { default as 'Gentoo Eclass' } from '../data/Gentoo_20_Eclass.mjs'
export { default as 'Gerber Image' } from '../data/Gerber_20_Image.mjs'
export { default as 'Gettext Catalog' } from '../data/Gettext_20_Catalog.mjs'
export { default as 'Gherkin' } from '../data/Gherkin.mjs'
export { default as 'Git Attributes' } from '../data/Git_20_Attributes.mjs'
export { default as 'Git Config' } from '../data/Git_20_Config.mjs'
export { default as 'Git Revision List' } from '../data/Git_20_Revision_20_List.mjs'
export { default as 'Gleam' } from '../data/Gleam.mjs'
export { default as 'Glimmer JS' } from '../data/Glimmer_20_JS.mjs'
export { default as 'Glimmer TS' } from '../data/Glimmer_20_TS.mjs'
export { default as 'Glyph' } from '../data/Glyph.mjs'
export { default as 'Glyph Bitmap Distribution Format' } from '../data/Glyph_20_Bitmap_20_Distribution_20_Format.mjs'
export { default as 'Gnuplot' } from '../data/Gnuplot.mjs'
export { default as 'Go' } from '../data/Go.mjs'
export { default as 'Go Checksums' } from '../data/Go_20_Checksums.mjs'
export { default as 'Go Module' } from '../data/Go_20_Module.mjs'
export { default as 'Go Workspace' } from '../data/Go_20_Workspace.mjs'
export { default as 'Godot Resource' } from '../data/Godot_20_Resource.mjs'
export { default as 'Golo' } from '../data/Golo.mjs'
export { default as 'Gosu' } from '../data/Gosu.mjs'
export { default as 'Grace' } from '../data/Grace.mjs'
export { default as 'Gradle' } from '../data/Gradle.mjs'
export { default as 'Gradle Kotlin DSL' } from '../data/Gradle_20_Kotlin_20_DSL.mjs'
export { default as 'Grammatical Framework' } from '../data/Grammatical_20_Framework.mjs'
export { default as 'Graph Modeling Language' } from '../data/Graph_20_Modeling_20_Language.mjs'
export { default as 'GraphQL' } from '../data/GraphQL.mjs'
export { default as 'Graphviz (DOT)' } from '../data/Graphviz_20__28_DOT_29_.mjs'
export { default as 'Groovy' } from '../data/Groovy.mjs'
export { default as 'Groovy Server Pages' } from '../data/Groovy_20_Server_20_Pages.mjs'
export { default as 'HAProxy' } from '../data/HAProxy.mjs'
export { default as 'HCL' } from '../data/HCL.mjs'
export { default as 'HIP' } from '../data/HIP.mjs'
export { default as 'HLSL' } from '../data/HLSL.mjs'
export { default as 'HOCON' } from '../data/HOCON.mjs'
export { default as 'HTML' } from '../data/HTML.mjs'
export { default as 'HTML+ECR' } from '../data/HTML_2b_ECR.mjs'
export { default as 'HTML+EEX' } from '../data/HTML_2b_EEX.mjs'
export { default as 'HTML+ERB' } from '../data/HTML_2b_ERB.mjs'
export { default as 'HTML+PHP' } from '../data/HTML_2b_PHP.mjs'
export { default as 'HTML+Razor' } from '../data/HTML_2b_Razor.mjs'
export { default as 'HTTP' } from '../data/HTTP.mjs'
export { default as 'HXML' } from '../data/HXML.mjs'
export { default as 'Hack' } from '../data/Hack.mjs'
export { default as 'Haml' } from '../data/Haml.mjs'
export { default as 'Handlebars' } from '../data/Handlebars.mjs'
export { default as 'Harbour' } from '../data/Harbour.mjs'
export { default as 'Hare' } from '../data/Hare.mjs'
export { default as 'Haskell' } from '../data/Haskell.mjs'
export { default as 'Haxe' } from '../data/Haxe.mjs'
export { default as 'HiveQL' } from '../data/HiveQL.mjs'
export { default as 'HolyC' } from '../data/HolyC.mjs'
export { default as 'Hosts File' } from '../data/Hosts_20_File.mjs'
export { default as 'Hy' } from '../data/Hy.mjs'
export { default as 'HyPhy' } from '../data/HyPhy.mjs'
export { default as 'IDL' } from '../data/IDL.mjs'
export { default as 'IGOR Pro' } from '../data/IGOR_20_Pro.mjs'
export { default as 'INI' } from '../data/INI.mjs'
export { default as 'IRC log' } from '../data/IRC_20_log.mjs'
export { default as 'ISPC' } from '../data/ISPC.mjs'
export { default as 'Idris' } from '../data/Idris.mjs'
export { default as 'Ignore List' } from '../data/Ignore_20_List.mjs'
export { default as 'ImageJ Macro' } from '../data/ImageJ_20_Macro.mjs'
export { default as 'Imba' } from '../data/Imba.mjs'
export { default as 'Inform 7' } from '../data/Inform_20_7.mjs'
export { default as 'Ink' } from '../data/Ink.mjs'
export { default as 'Inno Setup' } from '../data/Inno_20_Setup.mjs'
export { default as 'Io' } from '../data/Io.mjs'
export { default as 'Ioke' } from '../data/Ioke.mjs'
export { default as 'Isabelle' } from '../data/Isabelle.mjs'
export { default as 'Isabelle ROOT' } from '../data/Isabelle_20_ROOT.mjs'
export { default as 'J' } from '../data/J.mjs'
export { default as 'JAR Manifest' } from '../data/JAR_20_Manifest.mjs'
export { default as 'JCL' } from '../data/JCL.mjs'
export { default as 'JFlex' } from '../data/JFlex.mjs'
export { default as 'JSON' } from '../data/JSON.mjs'
export { default as 'JSON with Comments' } from '../data/JSON_20_with_20_Comments.mjs'
export { default as 'JSON5' } from '../data/JSON5.mjs'
export { default as 'JSONLD' } from '../data/JSONLD.mjs'
export { default as 'JSONiq' } from '../data/JSONiq.mjs'
export { default as 'Jai' } from '../data/Jai.mjs'
export { default as 'Janet' } from '../data/Janet.mjs'
export { default as 'Jasmin' } from '../data/Jasmin.mjs'
export { default as 'Java' } from '../data/Java.mjs'
export { default as 'Java Properties' } from '../data/Java_20_Properties.mjs'
export { default as 'Java Server Pages' } from '../data/Java_20_Server_20_Pages.mjs'
export { default as 'Java Template Engine' } from '../data/Java_20_Template_20_Engine.mjs'
export { default as 'JavaScript' } from '../data/JavaScript.mjs'
export { default as 'JavaScript+ERB' } from '../data/JavaScript_2b_ERB.mjs'
export { default as 'Jest Snapshot' } from '../data/Jest_20_Snapshot.mjs'
export { default as 'JetBrains MPS' } from '../data/JetBrains_20_MPS.mjs'
export { default as 'Jinja' } from '../data/Jinja.mjs'
export { default as 'Jison' } from '../data/Jison.mjs'
export { default as 'Jison Lex' } from '../data/Jison_20_Lex.mjs'
export { default as 'Jolie' } from '../data/Jolie.mjs'
export { default as 'Jsonnet' } from '../data/Jsonnet.mjs'
export { default as 'Julia' } from '../data/Julia.mjs'
export { default as 'Julia REPL' } from '../data/Julia_20_REPL.mjs'
export { default as 'Jupyter Notebook' } from '../data/Jupyter_20_Notebook.mjs'
export { default as 'Just' } from '../data/Just.mjs'
export { default as 'KDL' } from '../data/KDL.mjs'
export { default as 'KRL' } from '../data/KRL.mjs'
export { default as 'Kaitai Struct' } from '../data/Kaitai_20_Struct.mjs'
export { default as 'KakouneScript' } from '../data/KakouneScript.mjs'
export { default as 'KerboScript' } from '../data/KerboScript.mjs'
export { default as 'KiCad Layout' } from '../data/KiCad_20_Layout.mjs'
export { default as 'KiCad Legacy Layout' } from '../data/KiCad_20_Legacy_20_Layout.mjs'
export { default as 'KiCad Schematic' } from '../data/KiCad_20_Schematic.mjs'
export { default as 'Kickstart' } from '../data/Kickstart.mjs'
export { default as 'Kit' } from '../data/Kit.mjs'
export { default as 'Koka' } from '../data/Koka.mjs'
export { default as 'Kotlin' } from '../data/Kotlin.mjs'
export { default as 'Kusto' } from '../data/Kusto.mjs'
export { default as 'LFE' } from '../data/LFE.mjs'
export { default as 'LLVM' } from '../data/LLVM.mjs'
export { default as 'LOLCODE' } from '../data/LOLCODE.mjs'
export { default as 'LSL' } from '../data/LSL.mjs'
export { default as 'LTspice Symbol' } from '../data/LTspice_20_Symbol.mjs'
export { default as 'LabVIEW' } from '../data/LabVIEW.mjs'
export { default as 'Lark' } from '../data/Lark.mjs'
export { default as 'Lasso' } from '../data/Lasso.mjs'
export { default as 'Latte' } from '../data/Latte.mjs'
export { default as 'Lean' } from '../data/Lean.mjs'
export { default as 'Lean 4' } from '../data/Lean_20_4.mjs'
export { default as 'Leo' } from '../data/Leo.mjs'
export { default as 'Less' } from '../data/Less.mjs'
export { default as 'Lex' } from '../data/Lex.mjs'
export { default as 'LigoLANG' } from '../data/LigoLANG.mjs'
export { default as 'LilyPond' } from '../data/LilyPond.mjs'
export { default as 'Limbo' } from '../data/Limbo.mjs'
export { default as 'Linear Programming' } from '../data/Linear_20_Programming.mjs'
export { default as 'Linker Script' } from '../data/Linker_20_Script.mjs'
export { default as 'Linux Kernel Module' } from '../data/Linux_20_Kernel_20_Module.mjs'
export { default as 'Liquid' } from '../data/Liquid.mjs'
export { default as 'Literate Agda' } from '../data/Literate_20_Agda.mjs'
export { default as 'Literate CoffeeScript' } from '../data/Literate_20_CoffeeScript.mjs'
export { default as 'Literate Haskell' } from '../data/Literate_20_Haskell.mjs'
export { default as 'LiveCode Script' } from '../data/LiveCode_20_Script.mjs'
export { default as 'LiveScript' } from '../data/LiveScript.mjs'
export { default as 'Logos' } from '../data/Logos.mjs'
export { default as 'Logtalk' } from '../data/Logtalk.mjs'
export { default as 'LookML' } from '../data/LookML.mjs'
export { default as 'LoomScript' } from '../data/LoomScript.mjs'
export { default as 'Lua' } from '../data/Lua.mjs'
export { default as 'Luau' } from '../data/Luau.mjs'
export { default as 'M' } from '../data/M.mjs'
export { default as 'M3U' } from '../data/M3U.mjs'
export { default as 'M4' } from '../data/M4.mjs'
export { default as 'M4Sugar' } from '../data/M4Sugar.mjs'
export { default as 'MATLAB' } from '../data/MATLAB.mjs'
export { default as 'MAXScript' } from '../data/MAXScript.mjs'
export { default as 'MDX' } from '../data/MDX.mjs'
export { default as 'MLIR' } from '../data/MLIR.mjs'
export { default as 'MQL4' } from '../data/MQL4.mjs'
export { default as 'MQL5' } from '../data/MQL5.mjs'
export { default as 'MTML' } from '../data/MTML.mjs'
export { default as 'MUF' } from '../data/MUF.mjs'
export { default as 'Macaulay2' } from '../data/Macaulay2.mjs'
export { default as 'Makefile' } from '../data/Makefile.mjs'
export { default as 'Mako' } from '../data/Mako.mjs'
export { default as 'Markdown' } from '../data/Markdown.mjs'
export { default as 'Marko' } from '../data/Marko.mjs'
export { default as 'Mask' } from '../data/Mask.mjs'
export { default as 'Mathematica' } from '../data/Mathematica.mjs'
export { default as 'Maven POM' } from '../data/Maven_20_POM.mjs'
export { default as 'Max' } from '../data/Max.mjs'
export { default as 'Mercury' } from '../data/Mercury.mjs'
export { default as 'Mermaid' } from '../data/Mermaid.mjs'
export { default as 'Meson' } from '../data/Meson.mjs'
export { default as 'Metal' } from '../data/Metal.mjs'
export { default as 'Microsoft Developer Studio Project' } from '../data/Microsoft_20_Developer_20_Studio_20_Project.mjs'
export { default as 'Microsoft Visual Studio Solution' } from '../data/Microsoft_20_Visual_20_Studio_20_Solution.mjs'
export { default as 'MiniD' } from '../data/MiniD.mjs'
export { default as 'MiniYAML' } from '../data/MiniYAML.mjs'
export { default as 'MiniZinc' } from '../data/MiniZinc.mjs'
export { default as 'MiniZinc Data' } from '../data/MiniZinc_20_Data.mjs'
export { default as 'Mint' } from '../data/Mint.mjs'
export { default as 'Mirah' } from '../data/Mirah.mjs'
export { default as 'Modelica' } from '../data/Modelica.mjs'
export { default as 'Modula-2' } from '../data/Modula-2.mjs'
export { default as 'Modula-3' } from '../data/Modula-3.mjs'
export { default as 'Module Management System' } from '../data/Module_20_Management_20_System.mjs'
export { default as 'Mojo' } from '../data/Mojo.mjs'
export { default as 'Monkey' } from '../data/Monkey.mjs'
export { default as 'Monkey C' } from '../data/Monkey_20_C.mjs'
export { default as 'Moocode' } from '../data/Moocode.mjs'
export { default as 'MoonBit' } from '../data/MoonBit.mjs'
export { default as 'MoonScript' } from '../data/MoonScript.mjs'
export { default as 'Motoko' } from '../data/Motoko.mjs'
export { default as 'Motorola 68K Assembly' } from '../data/Motorola_20_68K_20_Assembly.mjs'
export { default as 'Move' } from '../data/Move.mjs'
export { default as 'Muse' } from '../data/Muse.mjs'
export { default as 'Mustache' } from '../data/Mustache.mjs'
export { default as 'Myghty' } from '../data/Myghty.mjs'
export { default as 'NASL' } from '../data/NASL.mjs'
export { default as 'NCL' } from '../data/NCL.mjs'
export { default as 'NEON' } from '../data/NEON.mjs'
export { default as 'NL' } from '../data/NL.mjs'
export { default as 'NMODL' } from '../data/NMODL.mjs'
export { default as 'NPM Config' } from '../data/NPM_20_Config.mjs'
export { default as 'NSIS' } from '../data/NSIS.mjs'
export { default as 'NWScript' } from '../data/NWScript.mjs'
export { default as 'Nasal' } from '../data/Nasal.mjs'
export { default as 'Nearley' } from '../data/Nearley.mjs'
export { default as 'Nemerle' } from '../data/Nemerle.mjs'
export { default as 'NetLinx' } from '../data/NetLinx.mjs'
export { default as 'NetLinx+ERB' } from '../data/NetLinx_2b_ERB.mjs'
export { default as 'NetLogo' } from '../data/NetLogo.mjs'
export { default as 'NewLisp' } from '../data/NewLisp.mjs'
export { default as 'Nextflow' } from '../data/Nextflow.mjs'
export { default as 'Nginx' } from '../data/Nginx.mjs'
export { default as 'Nickel' } from '../data/Nickel.mjs'
export { default as 'Nim' } from '../data/Nim.mjs'
export { default as 'Ninja' } from '../data/Ninja.mjs'
export { default as 'Nit' } from '../data/Nit.mjs'
export { default as 'Nix' } from '../data/Nix.mjs'
export { default as 'Noir' } from '../data/Noir.mjs'
export { default as 'Nu' } from '../data/Nu.mjs'
export { default as 'NumPy' } from '../data/NumPy.mjs'
export { default as 'Nunjucks' } from '../data/Nunjucks.mjs'
export { default as 'Nushell' } from '../data/Nushell.mjs'
export { default as 'OASv2-json' } from '../data/OASv2-json.mjs'
export { default as 'OASv2-yaml' } from '../data/OASv2-yaml.mjs'
export { default as 'OASv3-json' } from '../data/OASv3-json.mjs'
export { default as 'OASv3-yaml' } from '../data/OASv3-yaml.mjs'
export { default as 'OCaml' } from '../data/OCaml.mjs'
export { default as 'OMNeT++ MSG' } from '../data/OMNeT_2b__2b__20_MSG.mjs'
export { default as 'OMNeT++ NED' } from '../data/OMNeT_2b__2b__20_NED.mjs'
export { default as 'Oberon' } from '../data/Oberon.mjs'
export { default as 'ObjDump' } from '../data/ObjDump.mjs'
export { default as 'Object Data Instance Notation' } from '../data/Object_20_Data_20_Instance_20_Notation.mjs'
export { default as 'ObjectScript' } from '../data/ObjectScript.mjs'
export { default as 'Objective-C' } from '../data/Objective-C.mjs'
export { default as 'Objective-C++' } from '../data/Objective-C_2b__2b_.mjs'
export { default as 'Objective-J' } from '../data/Objective-J.mjs'
export { default as 'Odin' } from '../data/Odin.mjs'
export { default as 'Omgrofl' } from '../data/Omgrofl.mjs'
export { default as 'Opa' } from '../data/Opa.mjs'
export { default as 'Opal' } from '../data/Opal.mjs'
export { default as 'Open Policy Agent' } from '../data/Open_20_Policy_20_Agent.mjs'
export { default as 'OpenAPI Specification v2' } from '../data/OpenAPI_20_Specification_20_v2.mjs'
export { default as 'OpenAPI Specification v3' } from '../data/OpenAPI_20_Specification_20_v3.mjs'
export { default as 'OpenCL' } from '../data/OpenCL.mjs'
export { default as 'OpenEdge ABL' } from '../data/OpenEdge_20_ABL.mjs'
export { default as 'OpenQASM' } from '../data/OpenQASM.mjs'
export { default as 'OpenRC runscript' } from '../data/OpenRC_20_runscript.mjs'
export { default as 'OpenSCAD' } from '../data/OpenSCAD.mjs'
export { default as 'OpenStep Property List' } from '../data/OpenStep_20_Property_20_List.mjs'
export { default as 'OpenType Feature File' } from '../data/OpenType_20_Feature_20_File.mjs'
export { default as 'Option List' } from '../data/Option_20_List.mjs'
export { default as 'Org' } from '../data/Org.mjs'
export { default as 'OverpassQL' } from '../data/OverpassQL.mjs'
export { default as 'Ox' } from '../data/Ox.mjs'
export { default as 'Oxygene' } from '../data/Oxygene.mjs'
export { default as 'Oz' } from '../data/Oz.mjs'
export { default as 'P4' } from '../data/P4.mjs'
export { default as 'PDDL' } from '../data/PDDL.mjs'
export { default as 'PEG.js' } from '../data/PEG.js.mjs'
export { default as 'PHP' } from '../data/PHP.mjs'
export { default as 'PLSQL' } from '../data/PLSQL.mjs'
export { default as 'PLpgSQL' } from '../data/PLpgSQL.mjs'
export { default as 'POV-Ray SDL' } from '../data/POV-Ray_20_SDL.mjs'
export { default as 'Pact' } from '../data/Pact.mjs'
export { default as 'Pan' } from '../data/Pan.mjs'
export { default as 'Papyrus' } from '../data/Papyrus.mjs'
export { default as 'Parrot' } from '../data/Parrot.mjs'
export { default as 'Parrot Assembly' } from '../data/Parrot_20_Assembly.mjs'
export { default as 'Parrot Internal Representation' } from '../data/Parrot_20_Internal_20_Representation.mjs'
export { default as 'Pascal' } from '../data/Pascal.mjs'
export { default as 'Pawn' } from '../data/Pawn.mjs'
export { default as 'Pep8' } from '../data/Pep8.mjs'
export { default as 'Perl' } from '../data/Perl.mjs'
export { default as 'Pic' } from '../data/Pic.mjs'
export { default as 'Pickle' } from '../data/Pickle.mjs'
export { default as 'PicoLisp' } from '../data/PicoLisp.mjs'
export { default as 'PigLatin' } from '../data/PigLatin.mjs'
export { default as 'Pike' } from '../data/Pike.mjs'
export { default as 'Pip Requirements' } from '../data/Pip_20_Requirements.mjs'
export { default as 'Pkl' } from '../data/Pkl.mjs'
export { default as 'PlantUML' } from '../data/PlantUML.mjs'
export { default as 'Pod' } from '../data/Pod.mjs'
export { default as 'Pod 6' } from '../data/Pod_20_6.mjs'
export { default as 'PogoScript' } from '../data/PogoScript.mjs'
export { default as 'Polar' } from '../data/Polar.mjs'
export { default as 'Pony' } from '../data/Pony.mjs'
export { default as 'Portugol' } from '../data/Portugol.mjs'
export { default as 'PostCSS' } from '../data/PostCSS.mjs'
export { default as 'PostScript' } from '../data/PostScript.mjs'
export { default as 'PowerBuilder' } from '../data/PowerBuilder.mjs'
export { default as 'PowerShell' } from '../data/PowerShell.mjs'
export { default as 'Praat' } from '../data/Praat.mjs'
export { default as 'Prisma' } from '../data/Prisma.mjs'
export { default as 'Processing' } from '../data/Processing.mjs'
export { default as 'Procfile' } from '../data/Procfile.mjs'
export { default as 'Proguard' } from '../data/Proguard.mjs'
export { default as 'Prolog' } from '../data/Prolog.mjs'
export { default as 'Promela' } from '../data/Promela.mjs'
export { default as 'Propeller Spin' } from '../data/Propeller_20_Spin.mjs'
export { default as 'Protocol Buffer' } from '../data/Protocol_20_Buffer.mjs'
export { default as 'Protocol Buffer Text Format' } from '../data/Protocol_20_Buffer_20_Text_20_Format.mjs'
export { default as 'Public Key' } from '../data/Public_20_Key.mjs'
export { default as 'Pug' } from '../data/Pug.mjs'
export { default as 'Puppet' } from '../data/Puppet.mjs'
export { default as 'Pure Data' } from '../data/Pure_20_Data.mjs'
export { default as 'PureBasic' } from '../data/PureBasic.mjs'
export { default as 'PureScript' } from '../data/PureScript.mjs'
export { default as 'Pyret' } from '../data/Pyret.mjs'
export { default as 'Python' } from '../data/Python.mjs'
export { default as 'Python console' } from '../data/Python_20_console.mjs'
export { default as 'Python traceback' } from '../data/Python_20_traceback.mjs'
export { default as 'Q#' } from '../data/Q_23_.mjs'
export { default as 'QML' } from '../data/QML.mjs'
export { default as 'QMake' } from '../data/QMake.mjs'
export { default as 'Qt Script' } from '../data/Qt_20_Script.mjs'
export { default as 'Quake' } from '../data/Quake.mjs'
export { default as 'QuakeC' } from '../data/QuakeC.mjs'
export { default as 'QuickBASIC' } from '../data/QuickBASIC.mjs'
export { default as 'R' } from '../data/R.mjs'
export { default as 'RAML' } from '../data/RAML.mjs'
export { default as 'RBS' } from '../data/RBS.mjs'
export { default as 'RDoc' } from '../data/RDoc.mjs'
export { default as 'REALbasic' } from '../data/REALbasic.mjs'
export { default as 'REXX' } from '../data/REXX.mjs'
export { default as 'RMarkdown' } from '../data/RMarkdown.mjs'
export { default as 'RON' } from '../data/RON.mjs'
export { default as 'ROS Interface' } from '../data/ROS_20_Interface.mjs'
export { default as 'RPC' } from '../data/RPC.mjs'
export { default as 'RPGLE' } from '../data/RPGLE.mjs'
export { default as 'RPM Spec' } from '../data/RPM_20_Spec.mjs'
export { default as 'RUNOFF' } from '../data/RUNOFF.mjs'
export { default as 'Racket' } from '../data/Racket.mjs'
export { default as 'Ragel' } from '../data/Ragel.mjs'
export { default as 'Raku' } from '../data/Raku.mjs'
export { default as 'Rascal' } from '../data/Rascal.mjs'
export { default as 'Raw token data' } from '../data/Raw_20_token_20_data.mjs'
export { default as 'ReScript' } from '../data/ReScript.mjs'
export { default as 'Readline Config' } from '../data/Readline_20_Config.mjs'
export { default as 'Reason' } from '../data/Reason.mjs'
export { default as 'ReasonLIGO' } from '../data/ReasonLIGO.mjs'
export { default as 'Rebol' } from '../data/Rebol.mjs'
export { default as 'Record Jar' } from '../data/Record_20_Jar.mjs'
export { default as 'Red' } from '../data/Red.mjs'
export { default as 'Redcode' } from '../data/Redcode.mjs'
export { default as 'Redirect Rules' } from '../data/Redirect_20_Rules.mjs'
export { default as 'Regular Expression' } from '../data/Regular_20_Expression.mjs'
export { default as "Ren'Py" } from '../data/Ren_27_Py.mjs'
export { default as 'RenderScript' } from '../data/RenderScript.mjs'
export { default as 'Rez' } from '../data/Rez.mjs'
export { default as 'Rich Text Format' } from '../data/Rich_20_Text_20_Format.mjs'
export { default as 'Ring' } from '../data/Ring.mjs'
export { default as 'Riot' } from '../data/Riot.mjs'
export { default as 'RobotFramework' } from '../data/RobotFramework.mjs'
export { default as 'Roc' } from '../data/Roc.mjs'
export { default as 'Rocq Prover' } from '../data/Rocq_20_Prover.mjs'
export { default as 'Roff' } from '../data/Roff.mjs'
export { default as 'Roff Manpage' } from '../data/Roff_20_Manpage.mjs'
export { default as 'Rouge' } from '../data/Rouge.mjs'
export { default as 'RouterOS Script' } from '../data/RouterOS_20_Script.mjs'
export { default as 'Ruby' } from '../data/Ruby.mjs'
export { default as 'Rust' } from '../data/Rust.mjs'
export { default as 'SAS' } from '../data/SAS.mjs'
export { default as 'SCSS' } from '../data/SCSS.mjs'
export { default as 'SELinux Policy' } from '../data/SELinux_20_Policy.mjs'
export { default as 'SMT' } from '../data/SMT.mjs'
export { default as 'SPARQL' } from '../data/SPARQL.mjs'
export { default as 'SQF' } from '../data/SQF.mjs'
export { default as 'SQL' } from '../data/SQL.mjs'
export { default as 'SQLPL' } from '../data/SQLPL.mjs'
export { default as 'SRecode Template' } from '../data/SRecode_20_Template.mjs'
export { default as 'SSH Config' } from '../data/SSH_20_Config.mjs'
export { default as 'STAR' } from '../data/STAR.mjs'
export { default as 'STL' } from '../data/STL.mjs'
export { default as 'STON' } from '../data/STON.mjs'
export { default as 'SVG' } from '../data/SVG.mjs'
export { default as 'SWIG' } from '../data/SWIG.mjs'
export { default as 'Sage' } from '../data/Sage.mjs'
export { default as 'Sail' } from '../data/Sail.mjs'
export { default as 'SaltStack' } from '../data/SaltStack.mjs'
export { default as 'Sass' } from '../data/Sass.mjs'
export { default as 'Scala' } from '../data/Scala.mjs'
export { default as 'Scaml' } from '../data/Scaml.mjs'
export { default as 'Scenic' } from '../data/Scenic.mjs'
export { default as 'Scheme' } from '../data/Scheme.mjs'
export { default as 'Scilab' } from '../data/Scilab.mjs'
export { default as 'Self' } from '../data/Self.mjs'
export { default as 'ShaderLab' } from '../data/ShaderLab.mjs'
export { default as 'Shell' } from '../data/Shell.mjs'
export { default as 'ShellCheck Config' } from '../data/ShellCheck_20_Config.mjs'
export { default as 'ShellSession' } from '../data/ShellSession.mjs'
export { default as 'Shen' } from '../data/Shen.mjs'
export { default as 'Sieve' } from '../data/Sieve.mjs'
export { default as 'Simple File Verification' } from '../data/Simple_20_File_20_Verification.mjs'
export { default as 'Singularity' } from '../data/Singularity.mjs'
export { default as 'Slang' } from '../data/Slang.mjs'
export { default as 'Slash' } from '../data/Slash.mjs'
export { default as 'Slice' } from '../data/Slice.mjs'
export { default as 'Slim' } from '../data/Slim.mjs'
export { default as 'Slint' } from '../data/Slint.mjs'
export { default as 'SmPL' } from '../data/SmPL.mjs'
export { default as 'Smali' } from '../data/Smali.mjs'
export { default as 'Smalltalk' } from '../data/Smalltalk.mjs'
export { default as 'Smarty' } from '../data/Smarty.mjs'
export { default as 'Smithy' } from '../data/Smithy.mjs'
export { default as 'Snakemake' } from '../data/Snakemake.mjs'
export { default as 'Solidity' } from '../data/Solidity.mjs'
export { default as 'Soong' } from '../data/Soong.mjs'
export { default as 'SourcePawn' } from '../data/SourcePawn.mjs'
export { default as 'Spline Font Database' } from '../data/Spline_20_Font_20_Database.mjs'
export { default as 'Squirrel' } from '../data/Squirrel.mjs'
export { default as 'Stan' } from '../data/Stan.mjs'
export { default as 'Standard ML' } from '../data/Standard_20_ML.mjs'
export { default as 'Starlark' } from '../data/Starlark.mjs'
export { default as 'Stata' } from '../data/Stata.mjs'
export { default as 'StringTemplate' } from '../data/StringTemplate.mjs'
export { default as 'Stylus' } from '../data/Stylus.mjs'
export { default as 'SubRip Text' } from '../data/SubRip_20_Text.mjs'
export { default as 'SugarSS' } from '../data/SugarSS.mjs'
export { default as 'SuperCollider' } from '../data/SuperCollider.mjs'
export { default as 'Survex data' } from '../data/Survex_20_data.mjs'
export { default as 'Svelte' } from '../data/Svelte.mjs'
export { default as 'Sway' } from '../data/Sway.mjs'
export { default as 'Sweave' } from '../data/Sweave.mjs'
export { default as 'Swift' } from '../data/Swift.mjs'
export { default as 'SystemVerilog' } from '../data/SystemVerilog.mjs'
export { default as 'TI Program' } from '../data/TI_20_Program.mjs'
export { default as 'TL-Verilog' } from '../data/TL-Verilog.mjs'
export { default as 'TLA' } from '../data/TLA.mjs'
export { default as 'TOML' } from '../data/TOML.mjs'
export { default as 'TSPLIB data' } from '../data/TSPLIB_20_data.mjs'
export { default as 'TSQL' } from '../data/TSQL.mjs'
export { default as 'TSV' } from '../data/TSV.mjs'
export { default as 'TSX' } from '../data/TSX.mjs'
export { default as 'TXL' } from '../data/TXL.mjs'
export { default as 'Tact' } from '../data/Tact.mjs'
export { default as 'Talon' } from '../data/Talon.mjs'
export { default as 'Tcl' } from '../data/Tcl.mjs'
export { default as 'Tcsh' } from '../data/Tcsh.mjs'
export { default as 'TeX' } from '../data/TeX.mjs'
export { default as 'Tea' } from '../data/Tea.mjs'
export { default as 'Terra' } from '../data/Terra.mjs'
export { default as 'Terraform Template' } from '../data/Terraform_20_Template.mjs'
export { default as 'Texinfo' } from '../data/Texinfo.mjs'
export { default as 'Text' } from '../data/Text.mjs'
export { default as 'TextGrid' } from '../data/TextGrid.mjs'
export { default as 'TextMate Properties' } from '../data/TextMate_20_Properties.mjs'
export { default as 'Textile' } from '../data/Textile.mjs'
export { default as 'Thrift' } from '../data/Thrift.mjs'
export { default as 'Toit' } from '../data/Toit.mjs'
export { default as 'Tor Config' } from '../data/Tor_20_Config.mjs'
export { default as 'Tree-sitter Query' } from '../data/Tree-sitter_20_Query.mjs'
export { default as 'Turing' } from '../data/Turing.mjs'
export { default as 'Turtle' } from '../data/Turtle.mjs'
export { default as 'Twig' } from '../data/Twig.mjs'
export { default as 'Type Language' } from '../data/Type_20_Language.mjs'
export { default as 'TypeScript' } from '../data/TypeScript.mjs'
export { default as 'TypeSpec' } from '../data/TypeSpec.mjs'
export { default as 'Typst' } from '../data/Typst.mjs'
export { default as 'Unified Parallel C' } from '../data/Unified_20_Parallel_20_C.mjs'
export { default as 'Unity3D Asset' } from '../data/Unity3D_20_Asset.mjs'
export { default as 'Unix Assembly' } from '../data/Unix_20_Assembly.mjs'
export { default as 'Uno' } from '../data/Uno.mjs'
export { default as 'UnrealScript' } from '../data/UnrealScript.mjs'
export { default as 'Untyped Plutus Core' } from '../data/Untyped_20_Plutus_20_Core.mjs'
export { default as 'UrWeb' } from '../data/UrWeb.mjs'
export { default as 'V' } from '../data/V.mjs'
export { default as 'VBA' } from '../data/VBA.mjs'
export { default as 'VBScript' } from '../data/VBScript.mjs'
export { default as 'VCL' } from '../data/VCL.mjs'
export { default as 'VHDL' } from '../data/VHDL.mjs'
export { default as 'Vala' } from '../data/Vala.mjs'
export { default as 'Valve Data Format' } from '../data/Valve_20_Data_20_Format.mjs'
export { default as 'Velocity Template Language' } from '../data/Velocity_20_Template_20_Language.mjs'
export { default as 'Vento' } from '../data/Vento.mjs'
export { default as 'Verilog' } from '../data/Verilog.mjs'
export { default as 'Vim Help File' } from '../data/Vim_20_Help_20_File.mjs'
export { default as 'Vim Script' } from '../data/Vim_20_Script.mjs'
export { default as 'Vim Snippet' } from '../data/Vim_20_Snippet.mjs'
export { default as 'Visual Basic .NET' } from '../data/Visual_20_Basic_20_.NET.mjs'
export { default as 'Visual Basic 6.0' } from '../data/Visual_20_Basic_20_6.0.mjs'
export { default as 'Volt' } from '../data/Volt.mjs'
export { default as 'Vue' } from '../data/Vue.mjs'
export { default as 'Vyper' } from '../data/Vyper.mjs'
export { default as 'WDL' } from '../data/WDL.mjs'
export { default as 'WGSL' } from '../data/WGSL.mjs'
export { default as 'Wavefront Material' } from '../data/Wavefront_20_Material.mjs'
export { default as 'Wavefront Object' } from '../data/Wavefront_20_Object.mjs'
export { default as 'Web Ontology Language' } from '../data/Web_20_Ontology_20_Language.mjs'
export { default as 'WebAssembly' } from '../data/WebAssembly.mjs'
export { default as 'WebAssembly Interface Type' } from '../data/WebAssembly_20_Interface_20_Type.mjs'
export { default as 'WebIDL' } from '../data/WebIDL.mjs'
export { default as 'WebVTT' } from '../data/WebVTT.mjs'
export { default as 'Wget Config' } from '../data/Wget_20_Config.mjs'
export { default as 'Whiley' } from '../data/Whiley.mjs'
export { default as 'Wikitext' } from '../data/Wikitext.mjs'
export { default as 'Win32 Message File' } from '../data/Win32_20_Message_20_File.mjs'
export { default as 'Windows Registry Entries' } from '../data/Windows_20_Registry_20_Entries.mjs'
export { default as 'Witcher Script' } from '../data/Witcher_20_Script.mjs'
export { default as 'Wollok' } from '../data/Wollok.mjs'
export { default as 'World of Warcraft Addon Data' } from '../data/World_20_of_20_Warcraft_20_Addon_20_Data.mjs'
export { default as 'Wren' } from '../data/Wren.mjs'
export { default as 'X BitMap' } from '../data/X_20_BitMap.mjs'
export { default as 'X Font Directory Index' } from '../data/X_20_Font_20_Directory_20_Index.mjs'
export { default as 'X PixMap' } from '../data/X_20_PixMap.mjs'
export { default as 'X10' } from '../data/X10.mjs'
export { default as 'XC' } from '../data/XC.mjs'
export { default as 'XCompose' } from '../data/XCompose.mjs'
export { default as 'XML' } from '../data/XML.mjs'
export { default as 'XML Property List' } from '../data/XML_20_Property_20_List.mjs'
export { default as 'XPages' } from '../data/XPages.mjs'
export { default as 'XProc' } from '../data/XProc.mjs'
export { default as 'XQuery' } from '../data/XQuery.mjs'
export { default as 'XS' } from '../data/XS.mjs'
export { default as 'XSLT' } from '../data/XSLT.mjs'
export { default as 'Xmake' } from '../data/Xmake.mjs'
export { default as 'Xojo' } from '../data/Xojo.mjs'
export { default as 'Xonsh' } from '../data/Xonsh.mjs'
export { default as 'Xtend' } from '../data/Xtend.mjs'
export { default as 'YAML' } from '../data/YAML.mjs'
export { default as 'YANG' } from '../data/YANG.mjs'
export { default as 'YARA' } from '../data/YARA.mjs'
export { default as 'YASnippet' } from '../data/YASnippet.mjs'
export { default as 'Yacc' } from '../data/Yacc.mjs'
export { default as 'Yul' } from '../data/Yul.mjs'
export { default as 'ZAP' } from '../data/ZAP.mjs'
export { default as 'ZIL' } from '../data/ZIL.mjs'
export { default as 'Zeek' } from '../data/Zeek.mjs'
export { default as 'ZenScript' } from '../data/ZenScript.mjs'
export { default as 'Zephir' } from '../data/Zephir.mjs'
export { default as 'Zig' } from '../data/Zig.mjs'
export { default as 'Zimpl' } from '../data/Zimpl.mjs'
export { default as 'Zmodel' } from '../data/Zmodel.mjs'
export { default as 'cURL Config' } from '../data/cURL_20_Config.mjs'
export { default as 'crontab' } from '../data/crontab.mjs'
export { default as 'desktop' } from '../data/desktop.mjs'
export { default as 'dircolors' } from '../data/dircolors.mjs'
export { default as 'eC' } from '../data/eC.mjs'
export { default as 'edn' } from '../data/edn.mjs'
export { default as 'fish' } from '../data/fish.mjs'
export { default as 'hoon' } from '../data/hoon.mjs'
export { default as 'iCalendar' } from '../data/iCalendar.mjs'
export { default as 'jq' } from '../data/jq.mjs'
export { default as 'kvlang' } from '../data/kvlang.mjs'
export { default as 'mIRC Script' } from '../data/mIRC_20_Script.mjs'
export { default as 'mcfunction' } from '../data/mcfunction.mjs'
export { default as 'mdsvex' } from '../data/mdsvex.mjs'
export { default as 'mupad' } from '../data/mupad.mjs'
export { default as 'nanorc' } from '../data/nanorc.mjs'
export { default as 'nesC' } from '../data/nesC.mjs'
export { default as 'ooc' } from '../data/ooc.mjs'
export { default as 'q' } from '../data/q.mjs'
export { default as 'reStructuredText' } from '../data/reStructuredText.mjs'
export { default as 'robots.txt' } from '../data/robots.txt.mjs'
export { default as 'sed' } from '../data/sed.mjs'
export { default as 'templ' } from '../data/templ.mjs'
export { default as 'vCard' } from '../data/vCard.mjs'
export { default as 'wisp' } from '../data/wisp.mjs'
export { default as 'xBase' } from '../data/xBase.mjs'
