<?php
header("Content-Type: application/json");

$requestMethod = $_SERVER["REQUEST_METHOD"];
$request = $_GET['request'] ?? '';
switch ($requestMethod) {
    case 'GET':
        handleGet($request);
        break;
    case 'POST':
        handlePost();
        break;
    case 'PUT':
        handlePut($request);
        break;
    case 'DELETE':
        handleDelete($request);
        break;
    default:
        http_response_code(405);
        echo json_encode(["message" => "Method Not Allowed"]);
        break;
}

function handleGet($request) {
    $users = getUsers();
    if (empty($request)) {
        echo json_encode($users);
    } else {
        $userId = explode('/', $request)[0];
        $user = array_filter($users, fn($u) => $u['id'] == $userId);
        echo $user ? json_encode(array_values($user)[0]) : json_encode(["message" => "User not found"], 404);
    }
}

function handlePost() {
    $input = json_decode(file_get_contents("php://input"), true);
    $users = getUsers();
    $newUser = ["id" => end($users)['id'] + 1, "name" => $input['name'], "email" => $input['email']];
    $users[] = $newUser;
    saveUsers($users);
    echo json_encode($newUser, 201);
}

function handlePut($request) {
    $input = json_decode(file_get_contents("php://input"), true);
    $users = getUsers();
    $userId = explode('/', $request)[0];
    foreach ($users as &$user) {
        if ($user['id'] == $userId) {
            $user['name'] = $input['name'];
            $user['email'] = $input['email'];
            saveUsers($users);
            echo json_encode($user);
            return;
        }
    }
    echo json_encode(["message" => "User not found"], 404);
}

function handleDelete($request) {
    $users = getUsers();
    $userId = explode('/', $request)[0];
    foreach ($users as $key => $user) {
        if ($user['id'] == $userId) {
            unset($users[$key]);
            saveUsers($users);
            echo json_encode(["message" => "User deleted"]);
            return;
        }
    }
    echo json_encode(["message" => "User not found"], 404);
}

