<?php
header("Content-Type: application/json");
include 'conn.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(
    file_get_contents(
        'php://input'
    ),
    true
);

$uri = explode(
    basename(__DIR__)."/",   //noskaidro relatīvo ceļu
    $_SERVER['REQUEST_URI']
)[1]; 

$uri=explode(
    "/",
    $uri."/"
);
if ($uri[0]!=""){ 
	$table_name=$pref.$uri[0];
	switch ($method) {
		case 'GET':
			handleGet($uri[0],(int)$uri[1]);
			break;
		case 'POST':
			handlePost($uri[0],$input);
			break;
		case 'PUT':
			handlePut($uri[0],$input);
			break;
		case 'DELETE':
			handleDelete($uri[0],$input);
			break;
		default:
			echo json_encode(['message' => 'Invalid request method']);
			break;
	}
}

function handleGet($uri,$id) {
	global $conn;
	global $table_name;
    include '../inc/select.php';
    $stmt = $conn->prepare($sql);
   	if($id!=""){
   	     $stmt->bind_param(
   	        "i",
    	    $id
    	   );
   	}
	if ($stmt->execute()) {
	    $result = $stmt->get_result();
	    echo json_encode($result->fetch_all(MYSQLI_ASSOC));
	} else {
		echo json_encode(array("message"=>"Error: " . $sql . "<br>" . $stmt->error));
	}
}

function handlePost($uri,$input) {
	global $conn;
	global $table_name;
	include '../inc/insert.php';
    $stmt = $conn->prepare($sql);
	extract($input);
	$stmt->bind_param(
		"sss",
		$fname,
		$name,
		$date,
	);
    if ($stmt->execute()) {
	    $result = $stmt->get_result();
	    echo json_encode(['message' => 'User created successfully']);
	} else {
		echo json_encode(array("message"=>"Error: " . $sql . "<br>" . $stmt->error));
	}
}

function handlePut($uri,$input) {
	global $conn;
	global $table_name;
    include '../inc/update.php';
	$stmt = $conn->prepare($sql);
	extract($input);
   	if($id!=""){
	$stmt->bind_param(
		"sssi",
		$fname,
		$name,
		$date,
		$id
	);
   	}
    if ($stmt->execute()) {
	    $result = $stmt->get_result();
	    echo json_encode(['message' => 'User updated successfully']);
	} else {
		echo json_encode(array("message"=>"Error: " . $sql . "<br>" . $stmt->error));
	}
}

function handleDelete($uri,$input) {
	global $conn;
	global $table_name;
	include '../inc/delete.php';
    $stmt = $conn->prepare($sql);
	extract($input);
	if($id!=""){
		$stmt->bind_param(
			"i",
			$id
		);
   	}
    if ($stmt->execute()) {
	    $result = $stmt->get_result();
	    echo json_encode(['message' => 'User delete successfully']);
	} else {
		echo json_encode(array("message"=>"Error: " . $sql . "<br>" . $stmt->error));
	}}
?>