<?php
header("Content-Type: application/json");
include 'conn.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(
    file_get_contents(
        'php://input'
    ),
    true
);

$uri = explode(
    basename(__DIR__)."/",   //noskaidro relatīvo ceļu
    $_SERVER['REQUEST_URI']
)[1]; 

$uri=explode(
    "/",
    $uri."/"
);
    
switch ($method) {
    case 'GET':
        handleGet($uri[0],(int)$uri[1]);
        break;
    case 'POST':
        handlePost($uri[0],$input);
        break;
    case 'PUT':
        handlePut($uri[0],$input);
        break;
    case 'DELETE':
        handleDelete($uri[0],$input);
        break;
    default:
        echo json_encode(['message' => 'Invalid request method']);
        break;
}

function handleGet($uri,$id) {
echo $id;
global $conn;
    global $pref;
    $table_name=$pref.$uri;
    include 'inc/select.php';
    $stmt = $conn->prepare($sql);
   	if($id==""){
   	     $stmt->bind_param(
   	        "i",
    	    $id
    	   );
   	}
	if ($stmt->execute()) {
	    $result = $stmt->get_result();
	    echo json_encode($result->fetch_all(MYSQLI_ASSOC));
	} else {
		echo json_encode(array("message"=>"Error: " . $sql . "<br>" . $stmt->error));
	}
}

function handlePost($input) {
    global $conn;
    include 'inc/insert.php';
    $stmt = $conn->prepare($sql);
    $stmt->execute(['name' => $input['name'], 'email' => $input['email']]);
    echo json_encode(['message' => 'User created successfully']);
}

function handlePut($input) {
    global $conn;
    include 'inc/update.php';
    $stmt = $conn->prepare($sql);
    $stmt->execute(['name' => $input['name'], 'email' => $input['email'], 'id' => $input['id']]);
    echo json_encode(['message' => 'User updated successfully']);
}

function handleDelete( $input) {
    global $conn;
    include 'inc/delete.php';
    $stmt = $conn->prepare($sql);
    $stmt = $conn->prepare($sql);
    $stmt->execute(['id' => $input['id']]);
    echo json_encode(['message' => 'User deleted successfully']);
}
?>