<?php
header("Content-type:application/json");    // rezultāts būs JSON datne
include "conn.php";                         //DB savienojums

$uri = substr($_SERVER['REQUEST_URI'],stripos($_SERVER['REQUEST_URI'],basename(__DIR__))); //noskaidro relatīvo ceļu
$uri =str_replace("be/api/","",$uri);       //noņem lieko info
$method = $_SERVER['REQUEST_METHOD']; 
//echo($uri);

switch ($method | $uri) {
	case ($method == 'GET' && $uri == 'users/'):
		include "./inc/select.php";
		$stmt = $conn->prepare($sql);
		if ($stmt->execute()) {
			$result = $stmt->get_result();
			echo json_encode($result->fetch_all(MYSQLI_ASSOC));
		} else {
			echo json_encode(array("message"=>"Error: " . $sql . "
<br>" . $stmt->error));
		}
	break;
	case ($method == 'GET' && preg_match('/users\/[0-9]/', $uri)):
		preg_match('/([0-9]+)/', $uri,$matches);
		$id=$matches[0];
		include "inc/select.php";
		$stmt = $conn->prepare($sql);
		$stmt->bind_param(
			"i", 
			$id, 
		);
		if ($stmt->execute()) {
			$result = $stmt->get_result();
			echo json_encode($result->fetch_all(MYSQLI_ASSOC));
		} else {
			echo json_encode(array("message"=>"Error: " . $sql . "
	<br>" . $stmt->error));
		}
		break;
	case ($method == 'POST' && $uri == 'users/'):
		if(file_get_contents('php://input')){
		    $json = file_get_contents('php://input');
		    $arr= explode("------",$json);
		    //print_r($arr);
		    //print $json;
    		$data = json_decode($json, true);
    		include "inc/insert.php";
    		$name=$data["name"];
    		$fname=$data["fname"];
    		$date=$data["date"];
    		$stmt = $conn->prepare($sql);
    		$stmt->bind_param(
    			"sss", 
    			$name,
    			$fname,
    			$date
    		);
    		if ($stmt->execute()) {
    			echo json_encode(array("message"=>"New record created successfully"));
    		} else {
    			echo json_encode(array("message"=>"Error: " . $sql . "
		<br>" . $stmt->error));
    		}
		}else{
		    echo json_encode(array("message"=>"POST users"));  
		}
		break;
case ($method == 'PUT' && preg_match('/users\/[1-9]/', $uri)):
		preg_match('/([0-9]+)/', $uri,$matches);
		$id=$matches[0];
		if(file_get_contents('php://input')){
		    $json = file_get_contents('php://input');
    		$data = json_decode($json, true);
    		include "inc/insert.php";
    		$name=$data["name"];
    		$fname=$data["fname"];
    		$date=$data["date"];
    		//echo"$name-$fname-$date
    		include "inc/update.php";
    		$stmt = $conn->prepare($sql);
    		$stmt->bind_param(
    			"sssi", 
    			$name,
    			$fname,
    			$date,
    			$id
    		);
    		if ($stmt->execute()) {
    			echo json_encode(array("message"=>"Record updated successfully"));
    		} else {
    			echo json_encode(array("message"=>"Error: " . $sql . "
				<br>" . $stmt->error));
    		}
        }else{
          echo json_encode(array("message"=>"POST users/" .$id)); 
        }
		break;
	case ($method == 'DELETE' && preg_match('/users\/[1-9]/', $uri)):
		preg_match('/([0-9]+)/', $uri,$matches);
		$id=$matches[0];
		include "inc/delete.php";
		$stmt = $conn->prepare($sql);
		$stmt->bind_param(
			"i", 
			$id, 
		);
		if ($stmt->execute()) {
			echo json_encode(array("message"=>"Record deleted successfully"));
		} else {
			echo json_encode(array("message"=>"Error: " . $sql . "
					<br>" . $stmt->error));
		}
		break;
	default:
		echo json_encode(array("message"=>"error"));
	break;
}
//$stmt->close();
$conn->close();
?>