<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class NPCS extends Migration
{
    public function up()
    {
        $this->forge->addField([

            'id' => 
            [
                'type' => 'SERIAL4', 
                'null' => false,
            ],

            'name' =>
            [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],

            'description' =>
            [
                'type' => 'VARCHAR',
                'constraint' => 2500,
            ],

            'image' => 
            [
                'type' => 'JSONB',
                'null' => false,
            ],

            'armor_pieces' =>
            [
                'type' => 'INT[]',
                'null' => true,
            ],

            'weapons' =>
            [
                'type' => 'INT[]',
                'null' => true,
            ],

            'abilities' =>
            [
                'type' => 'INT[]',
                'null' => true,
            ],
            'health' =>
            [
                'type' => 'FLOAT',
                'null' => false,
                'default' => 0.0
            ]

        ]);
        $this->forge->addKey('id', true); 
        $this->forge->createTable('NPCS');  
    }

    public function down()
    {
        $this->forge->dropTable('NPCS'); 
    }
}
