<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class MigrationTest extends Migration
{
    public function up() 
    {
        $this->forge->addField([ 

            'id' => 
            [
                'type' => 'SERIAL4', 
                'null' => false,
            ],
            
            'image' => 
            [
                'type' => 'JSONB',
                'null' => false,
            ],

            'name' =>
            [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
            
            'class' =>
            [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
            
            'SlashDamage' => 
            [
                'type' => 'FLOAT',
                'null' => false,
                'default' => 0.0,
            ],

            'BluntDamage' => 
            [
                'type' => 'FLOAT',
                'null' => false,
                'default' => 0.0,
            ],

            'description' =>
            [
                'type' => 'VARCHAR',
                'constraint' => 2500,
                'default' => '...',
            ],
            
        ]);
        $this->forge->addKey('id', true); 
        $this->forge->createTable('weapons');  
    }

    public function down() 
    {
        $this->forge->dropTable('weapons'); 
    }
}
