<?php
$host = 'localhost';
$db = 'praksesprojekts';
$user = 'root';
$password = '';

// Pārbauda, vai ID ir pieprasījumā
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die('Caurlaides ID nav norādīts vai ir nederīgs.');
}

$id = intval($_GET['id']); // Sanitizācija (drošība)

try {
    // Savienojums ar datubāzi
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Izgūst konkrētās caurlaides datus no datubāzes
    $stmt = $pdo->prepare("
        SELECT 
            p.id, 
            p.name,
            p.PIN, 
            p.QR
        FROM passes p
        WHERE p.id = :id
    ");
    $stmt->execute(['id' => $id]);
    $caurlaide = $stmt->fetch(PDO::FETCH_ASSOC);

    // Ja caurlaide netika atrasta
    if (!$caurlaide) {
        die('Caurlaide nav atrasta.');
    }
} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Caurlaide Nr. <?= htmlspecialchars($caurlaide['id']); ?></title>
    <link rel="stylesheet" href="../css/show.css">
</head>
<body>
    <div class="container">
        <h1>Caurlaide Nr. <?= htmlspecialchars($caurlaide['id']); ?></h1>
        <p>Šeit ir viesim pieejamā caurlaide:</p>

        <dl>
            <dt>Viesis:</dt>
            <dd><?= htmlspecialchars($caurlaide['name']); ?></dd>

            <dt>PIN kods:</dt>
            <dd><?= htmlspecialchars($caurlaide['PIN']); ?></dd>

            <dt>QR kods:</dt>
            <dd>
                <img src="data:image/png;base64,<?= base64_encode($caurlaide['QR']); ?>" alt="QR kods">
            </dd>
        </dl>

        <div class="actions">
            <a href="/praksesprojekts/sargs/sargs.index.php" class="btn btn-secondary">Atpakaļ</a>
        </div>
    </div>
</body>
</html>
