<?php
// Savienojums ar datubāzi
$host = 'localhost';
$db = 'praksesprojekts';
$user = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Ja forma ir nosūtīta
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Iegūstam formu datus
        $name = trim($_POST['name'] ?? '');
        $company_id = $_POST['company_id'] ?? '';
        $phone = trim($_POST['phone'] ?? '');
        $date = $_POST['date'] ?? '';
        $remaining = $_POST['remaining'] ?? '';

        // Pārbaude, vai visi nepieciešamie dati ir nodoti
        if (empty($name) || empty($company_id) || empty($phone) || empty($date) || empty($remaining)) {
            echo 'Visi lauki jāaizpilda.';
            exit;
        }

        // Validējam telefona numuru (piemērs ar regulāro izteiksmi)
        if (!preg_match("/^\+?\d{8,15}$/", $phone)) {
            echo "Nederīgs telefona numurs.";
            exit;
        }

        // Validējam datumu, lai tas nebūtu pagātnē
        if (strtotime($date) < time()) {
            echo "Datums nevar būt pagātnē.";
            exit;
        }

        // Sagatavojam procedūras izsaukumu
        $stmt = $pdo->prepare("CALL create_pass(:name, :company_id, :phone, :date, :remaining, @pass_id, @PIN, @QR)");

        // Izpildām procedūru ar parametriem
        $stmt->execute([
            ':name' => $name,
            ':company_id' => $company_id,
            ':phone' => $phone,
            ':date' => $date,
            ':remaining' => $remaining
        ]);

        // Iegūstam pēdējo caurlaides ID izmantojot MAX(id)
        $stmt = $pdo->prepare("SELECT MAX(id) AS last_id FROM passes");
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $lastId = $result['last_id'];

        // Pāradresējam uz saraksta lapu pēc pievienošanas
        header("Location: uznemums.show.php?id=$lastId");
        exit;
    }

    // Iegūstam uzņēmumu sarakstu, lai parādītu izvēlni formā
    $stmt = $pdo->prepare("SELECT id, name FROM companies");
    $stmt->execute();
    $companies = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jauna Caurlaide</title>
    <link rel="stylesheet" href="../css/create.css">
    <script src="/js/uznemums.js"></script>
</head>
<body>
    <div class="container">
        <!-- Header ar izvēlnēm -->
        <header>
            <nav>
                <ul class="menu">
                    <li class="menu-item"><a href="/praksesprojekts/sargs/sargs.index.php">Sargs</a></li>
                    <li class="menu-item"><a href="/praksesprojekts/uznemums/uznemums.index.php">Uzņēmums</a></li>
                    <li class="menu-item"><a href="/praksesprojekts/administracija/administracija.index.php">Administrācija</a></li>
                </ul>
            </nav>
        </header>

        <main>
            <h1>Jauna Caurlaide</h1>
            <p>Šeit varat pievienot jaunu viesi.</p>

            <!-- Jauna caurlaide forma -->
            <form action="uznemums.create.php" method="POST">
                <label for="name">Viesis:</label>
                <input type="text" name="name" id="name" required placeholder="Ievadiet viesi">

                <label for="company_id">Uzņēmums:</label>
                <select name="company_id" id="company_id" required>
                    <option value="">Izvēlēties uzņēmumu</option>
                    <?php foreach ($companies as $company): ?>
                        <option value="<?= htmlspecialchars($company['id']) ?>"><?= htmlspecialchars($company['name']) ?></option>
                    <?php endforeach; ?>
                </select>

                <label for="phone">Telefons:</label>
                <input type="text" name="phone" id="phone" required placeholder="Ievadiet telefonu">

                <label for="date">Datums un laiks:</label>
                <input type="datetime-local" name="date" id="date" required>

                <label for="remaining">Atlikušas reizes:</label>
                <input type="number" name="remaining" id="remaining" required placeholder="Ievadiet atlikušās reizes" min="0">

                <div class="form-actions">
                    <a href="uznemums.index.php" class="btn btn-secondary">Atcelt</a>
                    <button type="submit" class="btn btn-success">Pievienot Caurlaidi</button>
                </div>
            </form>
        </main>

        <!-- Footer -->
        <footer>
            <p>&copy; Svjatoslavs</p>
        </footer>
    </div>
</body>
</html>
