<?php
session_start(); // Sākam sesiju

// Savienojums ar datubāzi
$host = 'localhost';
$db = 'praksesprojekts';
$user = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Apstrādā formu, ja tā tiek nosūtīta
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $email = trim($_POST['email'] ?? '');
        $password = trim($_POST['password'] ?? '');

        // Validācija
        if (empty($email) || empty($password)) {
            $error_message = "Lūdzu, ievadiet e-pastu un paroli.";
        } else {
            // Mēģinām atrast lietotāju ar šo e-pastu
            $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email");
            $stmt->execute(['email' => $email]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($user && password_verify($password, $user['password'])) {
                // Ja parole ir pareiza, uzsākam sesiju un saglabājam lietotāja datus
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_name'] = $user['name'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['company_id'] = $user['company_id'];

                // Pārvirza uz galveno lapu pēc veiksmīgas autentifikācijas
                header("Location: /praksesprojekts/uznemums/uznemums.index.php");
                exit;
            } else {
                $error_message = "Nepareizs e-pasts vai parole.";
            }
        }
    }
} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Uzņēmuma Login</title>
    <link rel="stylesheet" href="../css/account.css">
    <script src="../js/login.js"></script>
</head>
<body>
    <div class="container">

        <main>
            <h1>Uzņēmuma Login</h1>

            <?php if (isset($error_message)): ?>
                <p style="color: red;"><?= htmlspecialchars($error_message) ?></p>
            <?php endif; ?>

            <form action="uznemums.login.php" method="POST">
                <label for="email">E-pasts:</label>
                <input type="email" name="email" id="email" required placeholder="Ievadiet e-pastu" value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">

                <label for="password">Parole:</label>
                <input type="password" name="password" id="password" required placeholder="Ievadiet paroli">
                
                <button type="button" id="togglePassword" onclick="togglePassword()">Rādīt paroli</button>



                <button type="submit" class="btn btn-primary">Pieslēgties</button>
            </form>
        </main>

        <footer>
            <p>&copy; 2024 Svjatoslavs</p>
        </footer>
    </div>
</body>
</html>
