<?php
$host = 'localhost';
$db = 'praksesprojekts';
$user = 'root';
$password = '';

if (!isset($_GET['id'])) {
    die('Nav norādīts darbinieka ID.');
}

$id = intval($_GET['id']); // Sanitizācija (drošība)

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Izgūst konkrētā darbinieka datus
    $stmt = $pdo->prepare("
        SELECT 
            u.id, 
            u.name, 
            u.phone, 
            u.email, 
            u.created_at, 
            c.name AS company_name,
            c.id AS company_id
        FROM users u
        LEFT JOIN companies c ON u.company_id = c.id
        WHERE u.id = ?
    ");
    $stmt->execute([$id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        die('Darbinieks nav atrasts.');
    }
} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Darbinieks: <?= htmlspecialchars($user['name']); ?></title>
    <link rel="stylesheet" href="../css/show.css">
</head>
<body>
    <div class="container bg-white shadow rounded-lg">
        <div class="header">
            <h1>Kompānijas <?= htmlspecialchars($user['company_name']); ?> darbinieks</h1>
            <p>Šeit redzams viens darbinieks.</p>
        </div>

        <dl>
            <dt>Vārds, uzvārds:</dt>
            <dd><?= htmlspecialchars($user['name']); ?></dd>

            <dt>Telefona numurs:</dt>
            <dd><?= htmlspecialchars($user['phone']); ?></dd>

            <dt>Email:</dt>
            <dd><?= htmlspecialchars($user['email']); ?></dd>

            <dt>Izveidots:</dt>
            <dd><?= htmlspecialchars($user['created_at']); ?></dd>
        </dl>

        <div class="actions">
            <a href="/praksesprojekts/administracija/administracija.show.php?id=<?= htmlspecialchars($user['company_id']); ?>" class="btn btn-secondary">ATPAKAĻ</a>
            <a href="adminuser.edit.php?company_id=<?= htmlspecialchars($user['company_id']); ?>&user_id=<?= htmlspecialchars($user['id']); ?>" class="btn btn-primary">LABOT</a>
            <form action="adminuser.delete.php" method="POST" class="inline-block">
        <input type="hidden" name="id" value="<?= htmlspecialchars($user['id']); ?>">
        <input type="hidden" name="company_id" value="<?= htmlspecialchars($user['company_id']); ?>">
        <button type="submit" class="btn btn-danger" onclick="return confirm('Vai tiešām gribat izdzēst šo darbinieku?')">DZĒST</button>
            </form>
        </div>
    </div>
</body>
</html>
