<?php
// Savienojums ar datubāzi
$host = 'localhost';
$db = 'praksesprojekts';
$user = 'root';
$password = '';

try {
    // Izveido savienojumu ar datubāzi
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Iegūstam darbinieka ID un kompānijas ID no URL
    $company_id = $_GET['company_id'] ?? null;
    $user_id = $_GET['user_id'] ?? null;
    if (!$company_id || !$user_id) {
        die("ID ir obligāts.");
    }

    // Iegūstam darbinieka datus no datubāzes
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = :user_id");
    $stmt->execute(['user_id' => $user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        die("Darbinieks ar šo ID netika atrasts.");
    }

    // Apstrādā formu nosūtīšanu (POST pieprasījums)
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Iegūstam jaunos datus no formas
        $name = trim($_POST['name'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $password = trim($_POST['password'] ?? '');

        // Validācija
        if (empty($name) || empty($phone) || empty($email)) {
            echo "Visi lauki jāaizpilda.";
            exit;
        }

        // Validējam telefona numuru
        if (!preg_match("/^\+?\d{8,15}$/", $phone)) {
            echo "Nederīgs telefona numurs.";
            exit;
        }

        // Ja parole nav tukša, tad mēs to atjauninām
        if (!empty($password)) {
            $password = password_hash($password, PASSWORD_DEFAULT);  // Parole tiek šifrēta
        } else {
            $password = $user['password']; // Ja parole nav mainīta, saglabājam veco
        }

        // Izpildām SQL vaicājumu, lai atjauninātu datus
        $stmt = $pdo->prepare("UPDATE users SET name = :name, phone = :phone, email = :email, password = :password WHERE id = :user_id");
        $stmt->execute([
            'name' => $name,
            'phone' => $phone,
            'email' => $email,
            'password' => $password,
            'user_id' => $user_id
        ]);

        // Pāradresējam uz lietotāja skata lapu ar jaunajiem datiem
        header("Location: adminuser.show.php?id=" . urlencode($user['id']) . urlencode($company['id']));
        exit;

    }

} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Labot darbinieka informāciju</title>
    <link rel="stylesheet" href="../css/edit.css">
</head>
<body>

    <div class="container">
        <header>
            <nav>
                <ul class="menu">
                    <li><a href="adminuser.index.php">Darbinieki</a></li>
                    <li><a href="company.index.php">Uzņēmumi</a></li>
                </ul>
            </nav>
        </header>

        <main>
            <h1>Labot darbinieka: <?= htmlspecialchars($user['name']) ?></h1>
            <p>Šeit varat mainīt darbinieka informāciju.</p>

            <form method="POST" action="">
                <!-- Formas dati tiek nosūtīti, iekļaujot user_id kā hidden lauku -->
                <input type="hidden" name="user_id" value="<?= htmlspecialchars($user['id']) ?>">

                <div class="form-group">
                    <label for="name">Darbinieka vārds, uzvārds</label>
                    <input type="text" name="name" id="name" value="<?= htmlspecialchars($user['name']) ?>" required>
                </div>

                <div class="form-group">
                    <label for="phone">Darbinieka telefona numurs</label>
                    <input type="text" name="phone" id="phone" value="<?= htmlspecialchars($user['phone']) ?>" required>
                </div>

                <div class="form-group">
                    <label for="email">Darbinieka e-pasts</label>
                    <input type="email" name="email" id="email" value="<?= htmlspecialchars($user['email']) ?>" required>
                </div>

                <div class="form-group">
                    <label for="password">Darbinieka parole</label>
                    <input type="password" name="password" id="password" placeholder="Atstājiet tukšu, lai saglabātu veco paroli">
                </div>

                <div class="form-actions">
                    <a href="adminuser.show.php?id=<?= $user_id; ?>?id=<?= $company_id; ?>" class="btn btn-cancel">ATCELT</a>
                    <button type="submit" class="btn btn-save">SAGLABĀT</button>
                </div>
            </form>
        </main>

        <footer>
            <p>&copy; 2024 Tava Kompānija</p>
        </footer>
    </div>

</body>
</html>
