<?php
// Savienojums ar datubāzi
$host = 'localhost';
$db = 'praksesprojekts';
$user = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Ja forma ir iesniegta
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $name = trim($_POST['name'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $password = trim($_POST['password'] ?? '');
        $company_id = intval($_POST['company_id'] ?? 0);

        // Validācija
        if (empty($name) || empty($email) || empty($phone) || empty($password) || $company_id === 0) {
            echo 'Visi lauki jāaizpilda.';
            exit;
        }

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            echo 'Nederīgs e-pasta formāts.';
            exit;
        }

        // Paroles šifrēšana
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        // Datu saglabāšana datubāzē
        $stmt = $pdo->prepare("INSERT INTO users (name, email, phone, password, company_id, created_at) VALUES (:name, :email, :phone, :password, :company_id, NOW())");
        $stmt->execute([
            ':name' => $name,
            ':email' => $email,
            ':phone' => $phone,
            ':password' => $hashed_password,
            ':company_id' => $company_id
        ]);

        $user_id = $pdo->lastInsertId();

        header("Location: adminuser.show.php?id=$user_id");
        exit;
    }

    // Uzņēmumu iegūšana formu izvēlei
    $stmt = $pdo->query("SELECT id, name FROM companies");
    $companies = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pievienot jaunu darbinieku</title>
    <link rel="stylesheet" href="../css/create.css">
</head>
<body>
    <div class="container">
        <header>
            <nav>
                <ul class="menu">
                    <li class="menu-item"><a href="/praksesprojekts/sargs/sargs.index.php">Sargs</a></li>
                    <li class="menu-item"><a href="/praksesprojekts/uznemums/uznemums.index.php">Uzņēmums</a></li>
                    <li class="menu-item"><a href="/praksesprojekts/administracija/administracija.index.php">Administrācija</a></li>
                </ul>
            </nav>
        </header>

        <main>
            <h1>Pievienot jaunu darbinieku</h1>
            <p>Šeit varat pievienot jaunu darbinieku uzņēmumam.</p>

            <form action="adminuser.create.php" method="POST">
                <label for="name">Darbinieka vārds un uzvārds:</label>
                <input type="text" name="name" id="name" required placeholder="Ievadiet darbinieka vārdu un uzvārdu">

                <label for="email">E-pasts:</label>
                <input type="email" name="email" id="email" required placeholder="Ievadiet darbinieka e-pastu">

                <label for="phone">Telefona numurs:</label>
                <input type="text" name="phone" id="phone" required placeholder="Ievadiet darbinieka telefona numuru">

                <label for="password">Parole:</label>
                <input type="password" name="password" id="password" required placeholder="Ievadiet darbinieka paroli">

                <label for="company_id">Uzņēmums:</label>
                <select name="company_id" id="company_id" required>
                    <option value="">Izvēlēties uzņēmumu</option>
                    <?php foreach ($companies as $company): ?>
                        <option value="<?= htmlspecialchars($company['id']) ?>">
                            <?= htmlspecialchars($company['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>

                <div class="form-actions">
                    <a href="/praksesprojekts/administracija/administracija.index.php" class="btn btn-secondary">Atcelt</a>
                    <button type="submit" class="btn btn-success">Saglabāt</button>
                </div>
            </form>
        </main>

        <footer>
            <p>&copy; 2024 Svjatoslavs</p>
        </footer>
    </div>
</body>
</html>
