<?php
// Pieslēgšanās datubāzei
$host = 'localhost';
$db = 'praksesprojekts';
$user = 'root';
$password = '';

// Pārbauda, vai 'id' tiek nodots URL
if (!isset($_GET['id'])) {
    die('Nav norādīts uzņēmuma ID.');
}

$id = intval($_GET['id']); // Sanitizācija (drošība)

try {
    // Izveido savienojumu ar datubāzi
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Iegūst konkrētā uzņēmuma datus
    $stmt = $pdo->prepare("
        SELECT id, name, address
        FROM companies
        WHERE id = ?
    ");
    $stmt->execute([$id]);
    $company = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$company) {
        die('Uzņēmums nav atrasts.');
    }

    // Iegūst caurlaides datus
    $stmt = $pdo->prepare("
        SELECT id, name, date
        FROM passes
        WHERE company_id = ?
    ");
    $stmt->execute([$id]);
    $viesi = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Iegūst darbiniekus
    $stmt = $pdo->prepare("
    SELECT id, name, email, phone
        FROM users
        WHERE company_id = ?
    ");
    $stmt->execute([$id]);
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Uzņēmums <?= htmlspecialchars($company['name']); ?></title>
    <link rel="stylesheet" href="../css/show.css">
</head>
<body>
    <div class="container">
        <!-- Uzņēmuma detaļas -->
        <h1>Uzņēmums: <?= htmlspecialchars($company['name']); ?></h1>
<table>
    <thead>
        <tr>
        <th>Adrese: <?= htmlspecialchars($company['address']); ?></th>
        </tr>
    </thead>
</table>
        
        <!-- Caurlaides -->
        <h2>Caurlaides</h2>
        <table>
            <thead>
                <tr>
                    <th>Viesa vārds</th>
                    <th>Datums</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($viesi as $viesis): ?>
                    <tr>
                        <td><?= htmlspecialchars($viesis['name']); ?></td>
                        <td><?= htmlspecialchars($viesis['date']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <!-- Darbinieki -->
        <h2>Darbinieki</h2>
        <table>
            <thead>
                <tr>
                    <th>Darbinieks</th>
                    <th>E-pasts</th>
                    <th>Telefona numurs</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?= htmlspecialchars($user['name']); ?></td>
                        <td><?= htmlspecialchars($user['email']); ?></td>
                        <td><?= htmlspecialchars($user['phone']); ?></td>
                        <td>
                            <a href="/praksesprojekts/adminuser/adminuser.show.php?id=<?= $user['id']; ?>?id=<?= $company['id']; ?>">Apskatīt</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <!-- Dzēšanas pogas -->
        <div class="actions">
            <a href="administracija.index.php" class="btn btn-secondary">Atpakaļ</a>
            <a href="administracija.edit.php?id=<?= $company['id']; ?>" class="btn btn-primary">Rediģēt uzņēmumu</a>
            <a href="administracija.delete.php?id=<?= $company['id']; ?>" 
               class="btn btn-danger" 
               onclick="return confirm('Vai tiešām vēlaties dzēst šo uzņēmumu?')">Dzēst uzņēmumu</a>
            <a href="/praksesprojekts/adminuser/adminuser.create.php" class="btn btn-secondary">Pievienot darbinieku</a>
        </div>
    </div>
</body>
</html>
