<?php
// Savienojums ar datubāzi
$host = 'localhost';
$db = 'praksesprojekts';
$user = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Meklēšanas parametra apstrāde
    $search = $_GET['search'] ?? '';
    $searchQuery = '';
    $params = [];

    if (!empty($search)) {
        $searchQuery = " WHERE name LIKE :search";
        $params['search'] = '%' . $search . '%';
    }

    // Datu iegūšana no datubāzes ar pievienotu meklēšanas vaicājumu
    $stmt = $pdo->prepare("SELECT id, name FROM companies $searchQuery");
    $stmt->execute($params); // Pārraida parametru vērtības
    $companies = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Administrācija - Kompānijas</title>
    <link rel="stylesheet" href="../css/style.css">
</head>
<body>
    <div class="container">
        <!-- Header -->
        <header>
            <nav>
                <ul class="menu">
                    <li class="menu-item"><a href="/praksesprojekts/administracija/administracija.index.php">Administrācija</a></li>
                    <li class="menu-item"><a href="/praksesprojekts/welcome/welcome.html">Iziet</a></li>
                </ul>
            </nav>
        </header>

        <main>
            <h1>Uzņēmumi</h1>

        <!-- Poga Izveidot -->
        <div class="new-company-btn">
                <a href="/praksesprojekts/administracija/administracija.create.php" class="btn btn-success">
                    Izveidot kompāniju
                </a>
            </div>


            <!-- Meklēšanas forma -->
            <form method="GET" class="search-form">
                <input 
                    type="text" 
                    name="search" 
                    id="search" 
                    placeholder="" 
                    value="<?= htmlspecialchars($search) ?>">
                <button type="submit">Meklēt</button>
            </form>

            <!-- Tabula -->
            <table>
                <thead>
                    <tr>
                        <th>Kompānija</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($companies)): ?>
                        <?php foreach ($companies as $company): ?>
                            <tr>
                                <td><?= htmlspecialchars($company['name']) ?></td>
                                <td>
                                    <a href="/praksesprojekts/administracija/administracija.show.php?id=<?= urlencode($company['id']); ?>" class="btn btn-primary">Apskatīt</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="2">Nav atrasti dati.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </main>

        <!-- Footer -->
        <footer>
            <p>&copy; 2024 Svjatoslavs</p>
        </footer>
    </div>
</body>
</html>
