<?php
// Savienojums ar datubāzi
$host = 'localhost';
$db = 'praksesprojekts';
$user = 'root';
$password = '';

try {
    // Izveido savienojumu ar datubāzi
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Iegūstam uzņēmuma ID no URL
    $id = $_GET['id'] ?? null;
    if (!$id) {
        die("Uzņēmuma ID nav norādīts.");
    }

    // Iegūstam uzņēmuma datus pēc ID
    $stmt = $pdo->prepare("SELECT * FROM companies WHERE id = :id");
    $stmt->execute(['id' => $id]);
    $company = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$company) {
        die("Uzņēmums ar šo ID netika atrasts.");
    }

    // Apstrādā formu nosūtīšanu (POST pieprasījums)
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Iegūstam jaunos datus no formas
        $name = trim($_POST['name'] ?? '');
        $address = trim($_POST['address'] ?? '');

        // Validācija
        if (empty($name) || empty($address)) {
            echo "Visi lauki jāaizpilda.";
            exit;
        }

        // Izpildām SQL vaicājumu, lai atjauninātu uzņēmuma datus
        $stmt = $pdo->prepare("UPDATE companies SET name = :name, address = :address WHERE id = :id");
        $stmt->execute([
            'name' => $name,
            'address' => $address,
            'id' => $id
        ]);

        // Pāradresē uz uzņēmuma skatīšanās lapu ar jaunajiem datiem
        header("Location: administracija.show.php?id=" . urlencode($id));
        exit;
    }

} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Labot uzņēmumu</title>
    <link rel="stylesheet" href="../css/edit.css">
</head>
<body>
    <div class="container">
        <h1>Labot uzņēmumu</h1>
        <p>Šeit varat mainīt uzņēmuma informāciju.</p>

        <form method="POST" action="">
            <input type="hidden" name="id" value="<?= htmlspecialchars($company['id']) ?>">

            <div class="form-group">
                <label for="name">Uzņēmuma nosaukums</label>
                <input type="text" name="name" id="name" value="<?= htmlspecialchars($company['name']) ?>" required>
            </div>

            <div class="form-group">
                <label for="address">Uzņēmuma adrese</label>
                <input type="text" name="address" id="address" value="<?= htmlspecialchars($company['address']) ?>" required>
            </div>

            <div class="form-actions">
                <a href="administracija.show.php?id=<?= urlencode($company['id']); ?>" class="btn btn-cancel">ATCELT</a>
                <button type="submit" class="btn btn-save">SAGLABĀT</button>
            </div>
        </form>
    </div>
</body>
</html>
