<?php
// Savienojums ar datubāzi
$host = 'localhost';
$db = 'praksesprojekts';
$user = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Ja forma ir nosūtīta
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Iegūstam formu datus
        $name = trim($_POST['name'] ?? '');
        $address = trim($_POST['address'] ?? '');

        // Pārbaudām, vai visi nepieciešamie dati ir aizpildīti
        if (empty($name) || empty($address)) {
            echo 'Visi lauki jāaizpilda.';
            exit;
        }

        try {
            // Ievadām jaunu kompāniju datubāzē
            $stmt = $pdo->prepare("INSERT INTO companies (name, address) VALUES (:name, :address)");
            $stmt->execute([
                ':name' => $name,
                ':address' => $address,
            ]);
        } catch (PDOException $e) {
            die("Kļūda saglabājot datus: " . $e->getMessage());
        }

        // Pāradresējam uz administrācijas lapu pēc pievienošanas
        header("Location: administracija.index.php");
        exit;
    }
} catch (PDOException $e) {
    die("Kļūda savienojoties ar datubāzi: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jauna Kompānija</title>
    <link rel="stylesheet" href="../css/create.css">
</head>
<body>
    <div class="container">
        <!-- Header ar izvēlnēm -->
        <header>
            <nav>
                <ul class="menu">
                    <li class="menu-item"><a href="/praksesprojekts/sargs/sargs.index.php">Sargs</a></li>
                    <li class="menu-item"><a href="/praksesprojekts/uznemums/uznemums.index.php">Uzņēmums</a></li>
                    <li class="menu-item"><a href="/praksesprojekts/administracija/administracija.index.php">Administrācija</a></li>
                </ul>
            </nav>
        </header>

        <main>
            <h1>Jauna Kompānija</h1>
            <p>Aizpildiet formu, lai pievienotu jaunu kompāniju.</p>

            <!-- Jaunas kompānijas forma -->
            <form action="administracija.create.php" method="POST">
                <label for="name">Kompānijas nosaukums:</label>
                <input type="text" name="name" id="name" required placeholder="Ievadiet kompānijas nosaukumu">

                <label for="address">Kompānijas adrese:</label>
                <input type="text" name="address" id="address" required placeholder="Ievadiet kompānijas adresi">

                <div class="form-actions">
                    <a href="administracija.index.php" class="btn btn-secondary">Atcelt</a>
                    <button type="submit" class="btn btn-success">Saglabāt</button>
                </div>
            </form>
        </main>

        <!-- Footer -->
        <footer>
            <p>&copy; Svjatoslavs</p>
        </footer>
    </div>
</body>
</html>
