<?php
// Norādīt pareizo ceļu uz PHPMailer
require 'C:\xampp\htdocs\PraksesProjekts\PHPMailer\src\PHPMailer.php';
require 'C:\xampp\htdocs\PraksesProjekts\PHPMailer\src\SMTP.php';
require 'C:\xampp\htdocs\PraksesProjekts\PHPMailer\src\Exception.php';

// Izmanto PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;


session_start();

// Funkcija, lai ģenerētu nejaušu hash verifikācijai
function generateVerificationHash() {
    return bin2hex(random_bytes(16));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    $phone = $_POST['phone'] ?? '';

    // Validācija
    if (empty($name) || empty($email) || empty($password) || empty($phone)) {
        echo "Visi lauki ir obligāti!";
        exit;
    }

    // Šifrējam paroli
    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

    // Ģenerējam unikālu verifikācijas hash
    $verificationHash = generateVerificationHash();

    // Sagatavojam savienojumu ar datubāzi
    $mysqli = new mysqli('localhost', 'root', '', 'praksesprojekts');
    if ($mysqli->connect_error) {
        die('Savienojuma kļūda: ' . $mysqli->connect_error);
    }

    // Ievietojam jauno lietotāju datubāzē
    $stmt = $mysqli->prepare("INSERT INTO users (name, email, account_activation_hash, password, phone, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
    $stmt->bind_param("sssss", $name, $email, $verificationHash, $hashedPassword, $phone);

    if ($stmt->execute()) {
        // Veidojam verifikācijas saiti
        $verificationLink = "http://localhost/praksesprojekts/adminaccount/admin.verify.php?token=$verificationHash";

            $mail = new PHPMailer(true);

            try {
                // Servera iestatījumi
                $mail->isSMTP();
                $mail->Host = 'smtp.gmail.com'; // Gmail SMTP serveris
                $mail->SMTPAuth = true;
                $mail->Username = 'praksesprojekts@gmail.com'; // Tavs Gmail e-pasts
                $mail->Password = 'jyjo gfts exzf sjpx'; // Tava Gmail App Password
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // Izmanto STARTTLS
                $mail->Port = 587; // Gmail STARTTLS ports
    
                // Saņēmējs un sūtītājs
                $mail->setFrom('praksesprojekts@gmail.com', 'caurlaide');
                $mail->addAddress($email, $name);
    
                // Satura detaļas
                $mail->isHTML(true);
                $mail->Subject = 'E-pasta verifikacija';
                $mail->Body = "Sveiki, $name!<br><br>Lūdzu, apstipriniet savu e-pastu, noklikšķinot uz saites zemāk:<br><a href='$verificationLink'>$verificationLink</a>";
                $mail->AltBody = "Sveiki, $name!\n\nLūdzu, apstipriniet savu e-pastu, noklikšķinot uz saites zemāk:\n$verificationLink";
    
                $mail->send();
                echo "Reģistrācija veiksmīga! Pārbaudiet savu e-pastu, lai verificētu kontu.";
            } catch (Exception $e) {
                echo "Kļūda nosūtot e-pastu: {$mail->ErrorInfo}";
            }
        } else {
            echo "Kļūda: " . $stmt->error;
        }
    
        $stmt->close();
        $mysqli->close();
    }
    ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Reģistrācija</title>
    <link rel="stylesheet" href="../css/account.css">
    <script src="../js/login.js"></script>


</head>
<body>
    <div class="container">
        <h1>Admin Reģistrācija</h1>
        <form method="POST" action="admin.register.php">
            <label for="name">Vārds:</label>
            <input type="text" name="name" id="name" placeholder="Ievadiet savu vārdu" required>

            <label for="email">E-pasts:</label>
            <input type="email" name="email" id="email" placeholder="Ievadiet savu e-pastu" required>

            <label for="password">Parole:</label>
            <input type="password" name="password" id="password" placeholder="Izvēlieties paroli" required>

            <label for="phone">Telefona numurs:</label>
            <input type="text" name="phone" id="phone" placeholder="Ievadiet telefona numuru" required>

            <button type="button" id="togglePassword" onclick="togglePassword()">Rādīt paroli</button>

            <button type="submit">Reģistrēties</button>
        </form>
        <a href="adminuser.login.php" class="btn btn-secondary">Pieslēgties</a>
    </div>
</body>
</html>
