<?php
session_start();
include '../database/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../users/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Pievienot jaunu komandu
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['team_name'])) {
    $team_name = $_POST['team_name'];
    $stmt = $pdo->prepare("INSERT INTO teams (name, created_by) VALUES (?, ?)");
    $stmt->execute([$team_name, $user_id]);
}

// Iegūt lietotāja izveidotās komandas
$teams = $pdo->prepare("SELECT * FROM teams WHERE created_by = ?");
$teams->execute([$user_id]);

// Iegūt komandas, kurās lietotājs ir dalībnieks
$joined_teams = $pdo->prepare("SELECT t.* FROM teams t JOIN team_members tm ON t.id = tm.team_id WHERE tm.user_id = ?");
$joined_teams->execute([$user_id]);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teams</title>
    <link rel="stylesheet" href="../css/style.css">
</head>
<body>
<nav>
    <ul>
        <li><a href="../dashboard.php">Dashboard</a></li>
        <li><a href="../calendar/calendar.php">Calendar</a></li>
        <li><a href="../tasks/tasks.php">All Tasks</a></li>
        <li><a href="../teams/teams.php">Teams</a></li>
        <li><a href="../friends/add_friend.php">Friends</a></li>
        <li><a href="../profile/profile.php">Profile</a></li>
        <li><a href="../users/logout.php">Logout</a></li>
    </ul>
</nav>

<main>
    <h2>Teams</h2>

    <h3>Create new team</h3>
    <form method="post">
        <label for="team_name">Team name:</label>
        <input type="text" name="team_name" id="team_name" required>
        <button type="submit">Create</button>
    </form>

    <h3>Your Teams</h3>
    <ul>
        <?php while ($team = $teams->fetch()) : ?>
            <li>
                <strong><?= htmlspecialchars($team['name']) ?></strong>
                <a href="team_view.php?team_id=<?= $team['id'] ?>">More</a>
            </li>
        <?php endwhile; ?>
    </ul>

    <h3>Teams, where you are a participant</h3>
    <ul>
        <?php while ($team = $joined_teams->fetch()) : ?>
            <li>
                <strong><?= htmlspecialchars($team['name']) ?></strong>
                <a href="team_view.php?team_id=<?= $team['id'] ?>">More</a>
            </li>
        <?php endwhile; ?>
    </ul>
</main>
</body>
</html>
