<?php
session_start();
include '../database/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../users/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

if (!isset($_GET['task_id'])) {
    header("Location: tasks.php");
    exit();
}

$task_id = $_GET['task_id'];

$stmt = $pdo->prepare("SELECT * FROM tasks WHERE id = ? AND calendar_id IN (SELECT id FROM calendars WHERE user_id = ?)");
$stmt->execute([$task_id, $user_id]);
$task = $stmt->fetch();

if (!$task) {
    header("Location: tasks.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['title'])) {
    $title = $_POST['title'];
    $start_datetime = $_POST['start_datetime'];
    $end_datetime = $_POST['end_datetime'];
    $calendar_id = $_POST['calendar_id'];
    
    $stmt = $pdo->prepare("UPDATE tasks SET title = ?, start_datetime = ?, end_datetime = ?, calendar_id = ? WHERE id = ?");
    $stmt->execute([$title, $start_datetime, $end_datetime, $calendar_id, $task_id]);
    
    header("Location: tasks.php");
    exit();
}

$calendars = $pdo->prepare("SELECT id, name FROM calendars WHERE user_id = ?");
$calendars->execute([$user_id]);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Task</title>
    <link rel="stylesheet" href="../css/style.css">
</head>
<body>
<nav>
    <ul>
        <li><a href="../dashboard.php">Dashboard</a></li>
        <li><a href="../calendar/calendar.php">Calendar</a></li>
        <li><a href="../tasks/tasks.php">All Tasks</a></li>
        <li><a href="../teams/teams.php">Teams</a></li>
        <li><a href="../friends/add_friend.php">Friends</a></li>
        <li><a href="../profile/profile.php">Profile</a></li>
        <li><a href="../users/logout.php">Logout</a></li>
    </ul>
</nav>

<main>
    <h2>Edit Task</h2>
    <form method="post">
        <label for="calendar_id">Calendar:</label>
        <select name="calendar_id" id="calendar_id" required>
            <?php while ($calendar = $calendars->fetch()) : ?>
                <option value="<?= $calendar['id'] ?>" <?= $calendar['id'] == $task['calendar_id'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($calendar['name']) ?>
                </option>
            <?php endwhile; ?>
        </select>

        <label for="title">Name:</label>
        <input type="text" name="title" id="title" value="<?= htmlspecialchars($task['title']) ?>" required>

        <label for="start_datetime">Start time:</label>
        <input type="datetime-local" name="start_datetime" id="start_datetime" 
               value="<?= date('Y-m-d\TH:i', strtotime($task['start_datetime'])) ?>" required>

        <label for="end_datetime">End time:</label>
        <input type="datetime-local" name="end_datetime" id="end_datetime" 
               value="<?= date('Y-m-d\TH:i', strtotime($task['end_datetime'])) ?>" required>

        <button type="submit">Save</button>
    </form>
</main>
</body>
</html>
