<?php
session_start();
include '../database/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../users/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Dzēst uzdevumu, ja pieprasīts
if (isset($_GET['delete_task'])) {
    $task_id = $_GET['delete_task'];
    $stmt = $pdo->prepare("DELETE FROM tasks WHERE id = ? AND calendar_id IN (SELECT id FROM calendars WHERE user_id = ?)");
    $stmt->execute([$task_id, $user_id]);
    header("Location: tasks.php");
    exit();
}

// Pievienot jaunu uzdevumu
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['title'])) {
    $title = $_POST['title'];
    $start_datetime = $_POST['start_datetime'];
    $end_datetime = $_POST['end_datetime'];
    $calendar_id = $_POST['calendar_id'];

    $stmt = $pdo->prepare("INSERT INTO tasks (title, start_datetime, end_datetime, calendar_id) VALUES (?, ?, ?, ?)");
    $stmt->execute([$title, $start_datetime, $end_datetime, $calendar_id]);
}

// Iegūt lietotāja kalendārus
$calendars = $pdo->prepare("SELECT id, name FROM calendars WHERE user_id = ?");
$calendars->execute([$user_id]);

// Iegūt visus uzdevumus lietotāja kalendāros
$tasks = $pdo->prepare("
    SELECT t.id, t.title, t.start_datetime, t.end_datetime, c.name as calendar_name 
    FROM tasks t 
    JOIN calendars c ON t.calendar_id = c.id 
    WHERE c.user_id = ? 
    ORDER BY t.start_datetime ASC
");
$tasks->execute([$user_id]);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tasks</title>
    <link rel="stylesheet" href="../css/style.css">
</head>
<body>
<nav>
    <ul>
        <li><a href="../dashboard.php">Dashboard</a></li>
        <li><a href="../calendar/calendar.php">Calendar</a></li>
        <li><a href="../tasks/tasks.php">All Tasks</a></li>
        <li><a href="../teams/teams.php">Teams</a></li>
        <li><a href="../friends/add_friend.php">Friends</a></li>
        <li><a href="../profile/profile.php">Profile</a></li>
        <li><a href="../users/logout.php">Logout</a></li>
    </ul>
</nav>

<main>
    <h2>Tasks</h2>

    <h3>Add new task</h3>
    <form method="post">
        <label for="title">Name:</label>
        <input type="text" name="title" id="title" required>

        <label for="start_datetime">Begin time:</label>
        <input type="datetime-local" name="start_datetime" id="start_datetime" required>

        <label for="end_datetime">End time:</label>
        <input type="datetime-local" name="end_datetime" id="end_datetime" required>

        <button type="submit">Add Task</button>
    </form>

    <h3>Existing Tasks</h3>
    <ul>
        <?php while ($task = $tasks->fetch()) : ?>
            <li>
                <strong><?= htmlspecialchars($task['title']) ?></strong>
                (<?= $task['start_datetime'] ?> - <?= $task['end_datetime'] ?>)
                <a href="tasks_edit.php?task_id=<?= $task['id'] ?>">Edit</a>
                <a href="tasks.php?delete_task=<?= $task['id'] ?>" onclick="return confirm('Are you sure you want to delete this task?');">Delete</a>
            </li>
        <?php endwhile; ?>
    </ul>
</main>
</body>
</html>
